#include "RTDS_Scheduler.h"

/*
** FUNCTION RTDS_Scheduler_start:
** ------------------------------
** Function used as entry point for a task running a given scheduler
*/
static void * RTDS_Scheduler_start( void * RTDS_Scheduler_instance )
    {
    /* Synchronize startup */
    RTDS_START_SYNCHRO_WAIT
    /* Run the instance */
    ( ( RTDS_Scheduler * )RTDS_Scheduler_instance )->run();
    return NULL;
    }

/*
** MACRO RTDS_SCHEDULER_START:
** ---------------------------
** Creates a task running a scheduler
*/
#define RTDS_SCHEDULER_START( SCHEDULER_INSTANCE ) \
    RTDS_CREATE_TASK( RTDS_DEFAULT_PROCESS_PRIORITY, &RTDS_Scheduler_start, SCHEDULER_INSTANCE )

