#ifndef _RTDS_ADDL_MACRO_H_
#define _RTDS_ADDL_MACRO_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "RTDS_OS.h"

#define RTDS_CREATE_TASK( TASK_PRIORITY, TASK_FUNCTION, FUNCTION_PARAMETER ) \
    RTDS_TaskCreate( "RTDS_Task", TASK_PRIORITY, TASK_FUNCTION, FUNCTION_PARAMETER )

#define RTDS_FORGET_INSTANCE_INFO \
    RTDS_ProcessForget( RTDS_currentContext, 0 )

#define RTDS_NEW_MESSAGE_QUEUE \
    RTDS_MsgQueueCreate()

#define RTDS_READ_MESSAGE_QUEUE( QUEUE, MESSAGE ) \
    RTDS_MsgQueueReceive( QUEUE, ( char * )MESSAGE, sizeof( RTDS_MessageHeader ), WAIT_FOREVER );

#define RTDS_SETUP_CURRENT_CONTEXT

#ifdef RTDS_SIMULATOR
    #define RTDS_GET_MESSAGE_UNIQUE_ID RTDS_GetMessageUniqueId()
    #define RTDS_RELEASE_MESSAGE_UNIQUE_ID( UniqueId ) RTDS_ReleaseMessageUniqueId( UniqueId )
#else
    #define RTDS_GET_MESSAGE_UNIQUE_ID 0
    #define RTDS_RELEASE_MESSAGE_UNIQUE_ID( UniqueId )
#endif 

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_ADDL_MACRO_H_ */

