#include <stdio.h>
#include <string.h>

#include "tci/tci.h"
#include "RTDS_TTCN_MACRO.h"
#include "RTDS_gen.h"
#include "tci/tciRequired.h"

typedef void RTDS_TTCN_ControlFunction(RTDS_GlobalProcessInfo*);

static TciModuleIdType RTDS_TTCN_currentRootModule = {"",""};

int                           RTDS_TTCN_GetProcessNumber(TciModuleIdType *);
TciModuleIdListType         * RTDS_TTCN_GetAllRootModules();
TciTestCaseIdListType       * RTDS_TTCN_GetModuleTestcases(TciModuleIdType *);
TciParameterTypeListType    * RTDS_TTCN_GetTestcaseParameters(TciTestCaseIdType*, TciModuleIdType *);
RTDS_TTCN_ControlFunction   * RTDS_TTCN_GetProcessFunction(TciModuleIdType *);


/*
** FUNCTION tciRootModule:
** -----------------------
*/

void tciRootModule(TciModuleIdType* moduleId)
  {
  int                   i = 0;
  short                 moduleFound = 0;
  long int              length = 0;
  TciModuleIdListType * moduleList;

  moduleList = RTDS_TTCN_GetAllRootModules();
  length = moduleList->length;
  for (i = 0; i < length; i++)
    {
    if (strcmp(moduleId->moduleName, moduleList->modList[i].moduleName) == 0)
      {
      moduleFound = 1;
      RTDS_TTCN_currentRootModule.moduleName = moduleList->modList[i].moduleName;
      RTDS_TTCN_currentRootModule.baseName = moduleList->modList[i].baseName;
      break;
      }
    }
  if (!moduleFound)
    {
    char errorMessage[100];
    sprintf(errorMessage, "%s is not an available module name", moduleId->moduleName);
    RTDS_TTCN_currentRootModule.moduleName = "";
    RTDS_TTCN_currentRootModule.baseName = "";
#ifndef RTDS_SIMULATOR
    tciError(errorMessage);
#endif
    }
  }


/*
** FUNCTION tciGetTestCases:
** -------------------------
*/

TciTestCaseIdListType* tciGetTestCases()
  {
  return RTDS_TTCN_GetModuleTestcases(&RTDS_TTCN_currentRootModule);
  }

/*
** FUNCTION tciGetTestCaseParameters:
** -------------------------
*/

TciParameterTypeListType* tciGetTestCaseParameters(TciTestCaseIdType* testCaseId)
  {
  return RTDS_TTCN_GetTestcaseParameters(testCaseId, &RTDS_TTCN_currentRootModule);
  }
  
  
  
  
/*
** FUNCTION tciStartControl:
** -------------------------
*/

TriComponentId * tciStartControl()
  {
  RTDS_TTCN_ControlFunction         * processFunction;
  int                                 processNumber;
  TriComponentId                    * componentId;
  RTDS_GlobalProcessInfo              localContext;
  RTDS_GlobalProcessInfo            * RTDS_currentContext = &localContext;

  if ((strcmp(RTDS_TTCN_currentRootModule.moduleName, "") == 0) || (strcmp(RTDS_TTCN_currentRootModule.baseName, "") == 0))
    return NULL;
  componentId = (TriComponentId*)RTDS_MALLOC(sizeof(TriComponentId));
  processNumber = RTDS_TTCN_GetProcessNumber(&RTDS_TTCN_currentRootModule);
  if (processNumber == 0)
    return NULL;
  processFunction = RTDS_TTCN_GetProcessFunction(&RTDS_TTCN_currentRootModule);
  if (processFunction == NULL)
    return NULL;

  RTDS_currentContext->sdlProcessNumber = 0;
  RTDS_currentContext->myRtosTaskId = (RTDS_RtosTaskId)0;
  RTDS_currentContext->sdlState = 0;
  RTDS_currentContext->next = NULL;
  RTDS_currentContext->parentSdlInstanceId = NULL;
  RTDS_currentContext->offspringSdlInstanceId = NULL;
  RTDS_currentContext->currentMessage = NULL;
  RTDS_currentContext->timerList = NULL;
  RTDS_currentContext->mySdlInstanceId = NULL;

  /* RTDS_STARTUP_PROCESS_CREATE(RTDS_TTCN_currentRootModule.baseName, processNumber, processFunction, RTDS_DEFAULT_PROCESS_PRIORITY); */
  RTDS_PROCESS_CREATE(RTDS_TTCN_currentRootModule.baseName, processNumber, processFunction, RTDS_DEFAULT_PROCESS_PRIORITY);

  componentId->compInst.data = NULL;
  componentId->compInst.bits = 0;
  componentId->compName = NULL;
  componentId->compType.baseName = NULL;
  componentId->compType.moduleName = NULL;

  /* RTDS_START_SYNCHRO_GO; */
  return componentId;
  }


