#ifdef __cplusplus
extern "C" {
#endif

#ifndef _RTDS_CMD_INTERPRETER_H_
#define _RTDS_CMD_INTERPRETER_H_


#ifdef RTDS_CMD_INTERPRETER
#include <string.h>
#include "RTDS_OS.h"

/* for type RTDS_CmdTraceConfig */
#include "RTDS_FormatTrace.h"


#define RTDS_ESCAPECHAR '|'
#define RTDS_CMD_DELIMITERCHAR '\n'
#define RTDS_PARAM_DELIMITERCHAR ' '

enum RTDS_CmdType {
	ACK_CMDID,
	STOP_CMDID,
	MSG2PROCID,
	MSG2PROCNAME,
	MSG2PROCNUM,
	TIMER_CMDID,
	SYSCLOCK_CMDID,
	TRACE_CMDID};

/*------------------------------------
 STRUCT: Specific command  structures 
	that gather all required information
	RTDS_CmdSendMsg : to send SDL-RT message from external program
	RTDS_CmdForceTimer : to force timer to go off (that will send a message)
	RTDS_CmdTraceOption : configure dynamic trace option
------------------------------------*/
typedef struct RTDS_CmdSendMsg2ProcId
	{
	long                   messageNumber;
	long                   dataLength;
	unsigned char        * pData;
	RTDS_SdlInstanceId   * receiver;
	RTDS_SdlInstanceId   * sender;
	} RTDS_CmdSendMsg2ProcId;

typedef struct RTDS_CmdSendMsg2ProcName
	{
	long                   messageNumber;
	long                   dataLength;
	unsigned char        * pData;
	char                 * receiver;
	char                 * sender;
	} RTDS_CmdSendMsg2ProcName;

typedef struct RTDS_CmdSendMsg2ProcNumber
	{
	long                   messageNumber;
	long                  dataLength;
	unsigned char       * pData;
	int                   receiver;
	int                   sender;
	} RTDS_CmdSendMsg2ProcNumber;


typedef struct RTDS_CmdForceTimer
	{
	RTDS_SdlInstanceId  * pId;
	long                  timerNum;
	} RTDS_CmdForceTimer;


/*------------------------------------
	UNION: info related to the command
	------------------------------------*/
typedef union RTDS_UnionCommandParam
	{
	struct RTDS_CmdSendMsg2ProcId RTDS_message2pId;
	struct RTDS_CmdSendMsg2ProcName RTDS_messagepName;
	struct RTDS_CmdSendMsg2ProcNumber RTDS_message2pNumber;
	struct RTDS_CmdForceTimer RTDS_timer;
	struct RTDS_CmdTraceConfig RTDS_traceConfig;
	long newSystemClock;
	} RTDS_UnionCommandParam;


int RTDS_InterpretCommand(char* pBuffer, enum RTDS_CmdType * commandId, RTDS_UnionCommandParam * *pCommandParam);
char* RTDS_PopStringParam(char *pBuf, char **currentParam);

/* External command */
#define MSG2PROCID_CMDSTR 			"MSG2PROCID"				/* Command for sending SDL Message using process ids */
#define MSG2PROCNAME_CMDSTR 		"MSG2PROCNAME"			/* Command for sending SDL Message using process names */
#define MSG2PROCNUM_CMDSTR			"MSG2PROCNUM" 			/* Command for sending SDL Message using process numbers */
#define TIMER_CMDSTR						"TIMER" 						/* Command for sending Timer Message */
#define SYSCLOCK_CMDSTR 				"CLOCK" 						/* Command to set system clock (RTDS_globalSystemInfo) */
#define STOP_CMDSTR 						"STOP"							/* Command for stoping program */
#define ACK_CMDSTR							"ACK" 							/* TRACE ACKNOWLEDGE */
#define TRESUME_CMDSTR					"TRACE RESUME"
#define TPAUSE_CMDSTR 					"TRACE PAUSE"
#define TALLEVENT_CMDSTR				"TRACE ALL EVENT"
#define TMESSAGE_CMDSTR 				"TRACE MESSAGE EVENT"
#define TMESSAGE_DATA_CMDSTR		"TRACE MESSAGE DATA"
#define TTIMER_CMDSTR 					"TRACE TIMER EVENT"
#define TPROCESS_CMDSTR 				"TRACE PROCESS EVENT"
#define TSEMAPHORE_CMDSTR 			"TRACE SEMAPHORE EVENT"
#define TSDLSTATE_CMDSTR				"TRACE SDLSTATE EVENT"
#define TCLOCK_CMDSTR 					"TRACE CLOCK EVENT"

#define TOPTION_ENABLE_CMDSTR 	"ENABLE"
#define TOPTION_DISABLE_CMDSTR	"DISABLE"



#endif /* RTDS_CMD_INTERPRETER */
#endif /* _RTDS_CMD_INTERPRETER_H_*/

#ifdef __cplusplus
}
#endif
