/***********************************************************************************
 *						RTDS COMMAND INTERPRETER
 * ---------------------------------------------------------------------------------
 *					+ RTDS_InterpretCommand
 *					+ RTDS_PopStringParam
 *
 ***********************************************************************************/

#ifdef RTDS_CMD_INTERPRETER
#include "RTDS_CmdInterpreter.h"

#ifndef __CYGWIN__
 #include <stdlib.h>	/* define strtoul */
#endif


/***********************************************************************************************************
 *								 FUNCTION  RTDS_InterpretCommand(...)
 *----------------------------------------------------------------------------------------------------------
 *	Purpose : The goal of this function is to decode a command and return :
 *		- an Id of the command received
 *		- a command specific stucture that is gathering all required parameters
 *	The input is a formated char*
 *
 *	Parameter:
 *		pBuffer : char*: IN : a formated command sting
 *			All command line are ended by '|\n' and all parameters delimited by '| '
 *		commandId : RTDS_CmdType *: OUT
 *			RTDS_CmdType : enum RTDS_CmdType {ACK, STOP, MSG, TIMER, CLOCK, TRACE};
 *		pCommandParam : RTDS_UnionCommandParam *: OUT
 *			Return struct pointer poperly filled out
 *************************************************************************************************************/

int RTDS_InterpretCommand(char* cmdToInterpret, enum RTDS_CmdType * commandId, RTDS_UnionCommandParam ** pCommandParam)
	{
	char *pBuffer;
	char *currentParam = NULL;
	RTDS_CmdForceTimer * pTimerParam;
	RTDS_CmdTraceConfig * pTraceConfParam;
	long systemTime = 0;

	pBuffer = cmdToInterpret;

	pBuffer = RTDS_PopStringParam(pBuffer, &currentParam);
	/* Skip '| ' */
	pBuffer+=2;

	if(!strcmp(currentParam, STOP_CMDSTR))
		{
		*commandId = STOP_CMDID;
		*pCommandParam = NULL;
		}
	else if(!strcmp(currentParam, ACK_CMDSTR))
		{
		*commandId = ACK_CMDID;
		*pCommandParam = NULL;
		}
	else if(!strcmp(currentParam, TIMER_CMDSTR))
		{
		pTimerParam = (RTDS_CmdForceTimer*) RTDS_MALLOC(sizeof(RTDS_CmdForceTimer));

		pTimerParam->pId = (RTDS_SdlInstanceId *)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer += 2;

		pTimerParam->timerNum = (long)strtoul(pBuffer, &pBuffer, 0);

		*commandId = TIMER_CMDID;
		*pCommandParam = (RTDS_UnionCommandParam *) pTimerParam;
		}
	else if(!strcmp(currentParam, MSG2PROCID_CMDSTR))
		{
		RTDS_CmdSendMsg2ProcId * pMsgSendParam;
		pMsgSendParam = (RTDS_CmdSendMsg2ProcId * ) RTDS_MALLOC(sizeof(RTDS_CmdSendMsg2ProcId));
	  pMsgSendParam->pData = NULL;

		pMsgSendParam->messageNumber = (long)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		pMsgSendParam->dataLength = (long)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		if (pMsgSendParam->dataLength != 0)
			{
			long dataLg = 0;
			void * dataPtr= NULL;

      /* === EB - 20/03/2009: Use data length to check if message data was correctly decoded */
			char * endPointer;

			endPointer = RTDS_stringToMessageData(pMsgSendParam->messageNumber, &dataLg, &dataPtr, pBuffer);
			if ( endPointer == pBuffer + pMsgSendParam->dataLength )
			  pMsgSendParam->pData = (	unsigned char *)dataPtr;
			else
			  pMsgSendParam->pData = NULL;
			pBuffer += pMsgSendParam->dataLength;
      /* === */
      
			/* Skip '| ' */
			pBuffer+=2;
			}
		pMsgSendParam->receiver = (RTDS_SdlInstanceId *)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		pMsgSendParam->sender =(RTDS_SdlInstanceId *)strtoul(pBuffer, &pBuffer, 0);
		*commandId = MSG2PROCID;
		*pCommandParam = (RTDS_UnionCommandParam *) pMsgSendParam;
		}
	else if((!strcmp(currentParam, MSG2PROCNAME_CMDSTR)))
		{
		RTDS_CmdSendMsg2ProcName * pMsgSendParam;
		pMsgSendParam = (RTDS_CmdSendMsg2ProcName * ) RTDS_MALLOC(sizeof(RTDS_CmdSendMsg2ProcName));
		pMsgSendParam->receiver = NULL;
		pMsgSendParam->sender = NULL;
	  pMsgSendParam->pData = NULL;

		pMsgSendParam->messageNumber = (long)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		pMsgSendParam->dataLength = (long)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		if (pMsgSendParam->dataLength != 0)
			{
			long dataLg = 0;
			void * dataPtr= NULL;

      /* === EB - 20/03/2009: Use data length to check if message data was correctly decoded */
			char * endPointer;

			endPointer = RTDS_stringToMessageData(pMsgSendParam->messageNumber, &dataLg, &dataPtr, pBuffer);
			if ( endPointer == pBuffer + pMsgSendParam->dataLength )
			  pMsgSendParam->pData = (	unsigned char *)dataPtr;
			else
			  pMsgSendParam->pData = NULL;
			pBuffer += pMsgSendParam->dataLength;
      /* === */

			/* Skip '| ' */
			pBuffer+=2;
			}
		RTDS_FREE(currentParam);
		pBuffer = RTDS_PopStringParam(pBuffer, &currentParam);
		pMsgSendParam->receiver = (char *)RTDS_MALLOC(strlen(currentParam)+1);
		*pMsgSendParam->receiver = '\0';
		strcpy(pMsgSendParam->receiver, currentParam);
		/* Skip '| ' */
		pBuffer+=2;

		RTDS_FREE(currentParam);
		pBuffer = RTDS_PopStringParam(pBuffer, &currentParam);
		pMsgSendParam->sender = (char *)RTDS_MALLOC(strlen(currentParam)+1);
		*pMsgSendParam->sender = '\0';
		strcpy(pMsgSendParam->sender, currentParam);

		*commandId = MSG2PROCNAME;
		*pCommandParam = (RTDS_UnionCommandParam *) pMsgSendParam;
		}
	else if((!strcmp(currentParam, MSG2PROCNUM_CMDSTR)))
		{
		RTDS_CmdSendMsg2ProcNumber * pMsgSendParam;
		pMsgSendParam = (RTDS_CmdSendMsg2ProcNumber * ) RTDS_MALLOC(sizeof(RTDS_CmdSendMsg2ProcNumber));
		pMsgSendParam->receiver = 0;
		pMsgSendParam->sender = 0;
	  pMsgSendParam->pData = NULL;

		pMsgSendParam->messageNumber = (long)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		pMsgSendParam->dataLength = (long)strtoul(pBuffer, &pBuffer, 0);
		/* Skip '| ' */
		pBuffer+=2;

		if (pMsgSendParam->dataLength != 0)
			{
			long dataLg = 0;
			void * dataPtr= NULL;

      /* === EB - 20/03/2009: Use data length to check if message data was correctly decoded */
			char * endPointer;

			endPointer = RTDS_stringToMessageData(pMsgSendParam->messageNumber, &dataLg, &dataPtr, pBuffer);
			if ( endPointer == pBuffer + pMsgSendParam->dataLength )
			  pMsgSendParam->pData = (	unsigned char *)dataPtr;
			else
			  pMsgSendParam->pData = NULL;
			pBuffer += pMsgSendParam->dataLength;
      /* === */
      
			/* Skip '| ' */
			pBuffer+=2;
			}
		RTDS_FREE(currentParam);
		pBuffer = RTDS_PopStringParam(pBuffer, &currentParam);
		pMsgSendParam->receiver = strtoul(currentParam,NULL,0);
		/* Skip '| ' */
		pBuffer+=2;

		RTDS_FREE(currentParam);
		pBuffer = RTDS_PopStringParam(pBuffer, &currentParam);
		pMsgSendParam->sender = strtoul(currentParam,NULL,0);

		*commandId = MSG2PROCNUM;
		*pCommandParam = (RTDS_UnionCommandParam *) pMsgSendParam;
		}
	else if(!strcmp(currentParam, SYSCLOCK_CMDSTR))
		{
		*commandId = SYSCLOCK_CMDID;
		systemTime = (long)strtoul(pBuffer, &pBuffer, 0);
		*pCommandParam = (RTDS_UnionCommandParam *) systemTime;
		}
	else
		{
		/* Assum command is a dynamic trace cnfiguration */
		*commandId = TRACE_CMDID;
		pTraceConfParam = (RTDS_CmdTraceConfig *) RTDS_MALLOC(sizeof(RTDS_CmdTraceConfig));
		/*Default value for status*/
		pTraceConfParam->status = -1;

		if(!strcmp(currentParam, TRESUME_CMDSTR))
			{
			pTraceConfParam->configId = TRACING;
			pTraceConfParam->status = 1;
			}
		else if (!strcmp(currentParam, TPAUSE_CMDSTR))
			{
			pTraceConfParam->configId = TRACING;
			pTraceConfParam->status = 0;
			}
		else if (!strcmp(currentParam, TALLEVENT_CMDSTR))
			pTraceConfParam->configId = ALL_SDLEVENT;
		else if (!strcmp(currentParam, TMESSAGE_CMDSTR))
			pTraceConfParam->configId = SDL_MSG;
		else if (!strcmp(currentParam, TMESSAGE_DATA_CMDSTR))
			pTraceConfParam->configId = SDL_MSG_DATA;
		else if (!strcmp(currentParam, TTIMER_CMDSTR))
			pTraceConfParam->configId = SDL_TIMER;
		else if (!strcmp(currentParam, TPROCESS_CMDSTR))
			pTraceConfParam->configId = SDL_PROCESS;
		else if (!strcmp(currentParam, TSEMAPHORE_CMDSTR))
			pTraceConfParam->configId = SDL_SEMAPHORE;
		else if (!strcmp(currentParam, TSDLSTATE_CMDSTR))
			pTraceConfParam->configId = SDL_STATE;
		else if (!strcmp(currentParam, TCLOCK_CMDSTR))
			pTraceConfParam->configId = SDL_CLOCK;

		if (pTraceConfParam->configId == ALL_SDLEVENT || pTraceConfParam->configId == SDL_MSG || pTraceConfParam->configId == SDL_MSG_DATA|| pTraceConfParam->configId == SDL_TIMER || pTraceConfParam->configId == SDL_PROCESS || pTraceConfParam->configId == SDL_SEMAPHORE || pTraceConfParam->configId == SDL_STATE || pTraceConfParam->configId == SDL_CLOCK )
			{
			RTDS_FREE(currentParam);
			currentParam = RTDS_PopStringParam(pBuffer, &currentParam);
			if (!strcmp(currentParam, TOPTION_ENABLE_CMDSTR))
				pTraceConfParam->status = 1;
			else if (!strcmp(currentParam, TOPTION_DISABLE_CMDSTR))
				pTraceConfParam->status = 0;
			}

			/* Set configured param struct */
			*pCommandParam = (RTDS_UnionCommandParam *) pTraceConfParam;
		}/*end of else*/

		/* The free below relies on the fact that RTDS_PopStringParam is always done with currentParam parameter... */
		RTDS_FREE(currentParam);
		return RTDS_OK;
	}



/*********************************************************
				RTDS_PopStringParam
 ---------------------------------------------------------
 Internal function that pop a string from the begining
 of pBuf to the RTDS_ESCAPECHAR followed by the
 RTDS_CMD_DELIMITERCHAR or the RTDS_PARAM_DELIMITERCHAR.
 This function return pBuf minus currentParam ()

 Read until '| ' cancel '||'
 set currentParam to the read string
***********************************************************/

char* RTDS_PopStringParam(char *pBuf, char **currentParam)
	{
	char* stringParam = NULL;
	int i=0;

	*currentParam = NULL;

	while (1)
		{
		if ((pBuf[i] != RTDS_ESCAPECHAR) && (pBuf[i+1] == RTDS_ESCAPECHAR) && ((pBuf[i+2] == RTDS_PARAM_DELIMITERCHAR )|| pBuf[i+2] == RTDS_CMD_DELIMITERCHAR))
			{
			/* End of param */
			stringParam = (char*)RTDS_MALLOC(i+2);
			memcpy(stringParam, pBuf, i+1);
			stringParam[i+1] = '\0';
			*currentParam = stringParam;
			return &pBuf[i+1];
			}
		else
			{
			/* increase offset */
			i++;
			}
		}
	}

#endif /* RTDS_CMD_INTERPRETER */
