/* PragmaDev RTDS ThreadX integration */

#include "RTDS_MACRO.h"
#include "RTDS_Utilities.h"
/* **************************************************************** *
 *	RTDS_MemAlloc
 * **************************************************************** *
 * Allocates memory
 * **************************************************************** *
 * Parameters:
 *	 the size of the memory space to allocate
 * Returns:
 *	 a void pointer on the allocated memory space
 * Note:
 *	 This function has been done to use ThreadX memory allocation
 *	 mechanism
 * **************************************************************** */

void *RTDS_MemAlloc(int size)
	{
	CHAR		*pointer;
	UINT		status;
	int 		i;

	status = tx_byte_allocate(&RTDS_globalBytePool, (VOID **) &pointer, size, TX_NO_WAIT);
	if (	status != TX_SUCCESS )
		{
		printf("Error in tx_byte_allocate: 0x%x\n",status);
		RTDS_SYSTEM_ERROR(RTDS_ERROR_MEMALLOC_ERROR);
		}

	/* Let's initialize the memory block otherwise Multi crashes when trying to read the new block */
	for (i=0;i<size;i++)
		*(pointer+i) = 0x00;

	return (void *)pointer;
	}



/* **************************************************************** *
 *	RTDS_MemFree
 * **************************************************************** *
 * Frees memory
 * **************************************************************** *
 * Parameters:
 *	 a void pointer on the allocated memory space
 * Returns:
 *	 nothing
 * Note:
 *	 This function has been done to use ThreadX memory allocation
 *	 mechanism
 * **************************************************************** */

void RTDS_MemFree(void * pointer)
	{

	if ( tx_byte_release( pointer ) != TX_SUCCESS )
		RTDS_SYSTEM_ERROR(RTDS_ERROR_MEMFREE_ERROR);

	}


