#ifndef _RTDS_MUTEX_SEMAPHORE_PROCESS_H_
#define _RTDS_MUTEX_SEMAPHORE_PROCESS_H_

#include "RTDS_SemaphoreProcess.h"

/*
** PROCESS RTDS_MutexSemaphoreProcess:
** -----------------------------------
*/

class RTDS_MutexSemaphoreProcess : public RTDS_SemaphoreProcess
  {
  public:
    RTDS_SdlInstanceId  * taker_instance_id;
    unsigned int          take_count;
    

    // Constructor:
    RTDS_MutexSemaphoreProcess(RTDS_Scheduler * parentScheduler);
    
    // Checks if the semaphore is available
    virtual long isAvailable() { return this->take_count != 0; };

    // Entry point for all transitions:
    short RTDS_executeTransition(RTDS_MessageHeader * currentMessage);

    // Entry point for transitions for continuous signals:
    short RTDS_continuousSignals(int * lowestPriority);
  };

#else

class RTDS_MutexSemaphoreProcess;

#endif
