/* PragmaDev RTDS win32 integration */

/* Include unistd when using a unix based system or cygwin */
#ifdef __CYGWIN__
#include <unistd.h>
#else
#include <stdlib.h>
#endif

#include "RTDS_MACRO.h"

#if defined(RTDS_FORMAT_TRACE)
#include "RTDS_FormatTrace.h"
#endif

#include "RTDS_gen.h"

#include "RTDS_Env_decl.h"

#include "RTDS_InstanceManager.h"


/*
** CONSTRUCTOR:
** ------------
*/

RTDS_Env_proc::RTDS_Env_proc(RTDS_Scheduler * parentScheduler) : RTDS_Proc(parentScheduler)
  {
  }


/*
** METHOD RTDS_continuousSignals:
** ------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

short RTDS_Env_proc::RTDS_continuousSignals(int * lowestPriority)
  {
  return 0;
  }


/*
** METHOD RTDS_executeTransition:
** ------------------------------
** Entry point for all transitions in process or procedure
*/

short RTDS_Env_proc::RTDS_executeTransition(RTDS_MessageHeader * currentMessage)
  {
  // Start transition goes into dummy state
  if ( currentMessage == NULL )
    {
    RTDS_setSdlState( RTDS_Idle );
    return 0;
    }
  // All other messages are just discarded
  else
    {
    RTDS_currentContext->currentMessage = currentMessage;
    
#ifdef RTDS_SIMULATOR
    RTDS_SIMULATOR_TRACE( RTDS_messageReceived , currentMessage , SELF , RTDS_currentContext );
    RTDS_ReleaseMessageUniqueId( currentMessage->messageUniqueId );
#endif

#ifdef RTDS_ENV_FREE_PARAMETER
    if ( currentMessage->pData != NULL )
      {
      RTDS_FREE( currentMessage->pData );
      }
#endif

    RTDS_FREE( currentMessage );
    RTDS_currentContext->currentMessage = NULL;
    }
  return 0;
  }


/*
** INSTANCE FACTORY:
** -----------------
** Static function creating an instance of the new task and creation of a
** new RTDS_InstanceManager instance associating this function to the current
** process number.
*/

static RTDS_Proc * createInstance(RTDS_Scheduler * parentScheduler)
  {
  return new RTDS_Env_proc(parentScheduler);
  }

static RTDS_InstanceManager instanceManager(RTDS_process_RTDS_Env, &createInstance);

