/* PragmaDev RTDS OSE Epsilon integration */

/*
 * BASIC DEFINES:
 * ------------------------------
 */
#define RTDS_TRUE 1
#define RTDS_FALSE 0


/*
 * DEFINE FOR QUEUE MANIPULATION:
 * ------------------------------
 */
#define RTDS_QUEUE_MAX_MSG			20														/* Maximum number of messages in a queue */
#define RTDS_QUEUE_MAX_MSG_LENGTH sizeof(RTDS_MessageHeader)	/* Maximum length of messages in a queue */


/*
 * DEFINE FOR SEMAPHORE MANIPULATION:
 * ------------------------------
 */
#define RTDS_SEMAPHORE_MAX_NAME_LENGTH	20	 /* Maximum length of a semaphore name */

#define RTDS_SEMAPHORE_TIME_OUT_FOREVER -1	 /* Time out option when taking the semaphore : wait forever */
#define RTDS_SEMAPHORE_TIME_OUT_NO_WAIT  0	 /* Time out option when taking the semaphore : no wait */

#define RTDS_SEMAPHORE_OPTION_PRIO			 2	 /* Semaphore creation option: queuing based on priority */
#define RTDS_SEMAPHORE_OPTION_FIFO			 3	 /* Semaphore creation option: queuing based on FIFO */

#define RTDS_BINARY_SEM_INITIAL_EMPTY 	 0	 /* Binary semaphore creation initial state: empty */
#define RTDS_BINARY_SEM_INITIAL_FULL		 1	 /* Binary semaphore creation initial state: full */

#define RTDS_MUTEX_SEM_DELETE_SAFE			 6	 /* Protects a task that owns the semaphore from unexpected deletion */
#define RTDS_MUTEX_SEM_INVERSION_SAFE 	 7	 /* Protect the system from priority inversion */


/*
 * DEFINE FOR PROCESS CREATION:
 * ----------------------------
 */
#define RTDS_HOLD 											 1	/* The newly created task will held at startup on the startup semaphore */
#define RTDS_NO_HOLD										 0	/* The newly created task will not held at startup on the startup semaphore */
#define RTDS_TASK_OPTIONS 							 0	/* TaskSpawn options */
#define RTDS_TASK_STACK_SIZE					2048	/* Stack size when creating a new task */
#define RTDS_DEFAULT_PROCESS_PRIORITY 	15	/* If priority not defined in SDL-RT, it will be given this value */



/* ************************************************************************************ *
 *									CRITICAL SECTION MACROS
 * ************************************************************************************ */
#define RTDS_CRITICAL_SECTION_DECL		RTDS_SemaphoreId RTDS_globalSystemSemId;
#define RTDS_CRITICAL_SECTION_PROTO 	extern RTDS_SemaphoreId RTDS_globalSystemSemId;
#define RTDS_CRITICAL_SECTION_INIT		RTDS_globalSystemSemId = create_sem( 1 )
#define RTDS_CRITICAL_SECTION_START 	wait_sem( RTDS_globalSystemSemId);
#define RTDS_CRITICAL_SECTION_STOP		signal_sem( RTDS_globalSystemSemId );
#define RTDS_CRITICAL_SECTION_POSTAMBLE kill_sem( RTDS_globalSystemSemId );


/* ************************************************************************************ *
 *									COVERAGE INFORMATION
 * ************************************************************************************ *
 * The coverage information is stored in an array of unsigned char. The SDL-RT symbol
 * number is used as an index; the value stored is the number of times the symbol has
 * been executed. It can not exceed 0xFF for each symbol.
 * ************************************************************************************ */
#ifdef RTDS_COVERAGE_NB_SYMBOLS
#define RTDS_COVERAGE_DECL		unsigned char  RTDS_globalCoverage[RTDS_COVERAGE_NB_SYMBOLS];
#define RTDS_COVERAGE_PROTO 	extern RTDS_COVERAGE_DECL
#define RTDS_COVERAGE_INIT \
	{ \
	int i; \
	for (i=0;i<RTDS_COVERAGE_NB_SYMBOLS;i++) \
		RTDS_globalCoverage[i]=0; \
	}
#define RTDS_COVERAGE_LOG(SYMBOL_NUMBER) \
	if (RTDS_globalCoverage[SYMBOL_NUMBER]!=0xFF) RTDS_globalCoverage[SYMBOL_NUMBER]++;
#else
#define RTDS_COVERAGE_DECL
#define RTDS_COVERAGE_PROTO
#define RTDS_COVERAGE_INIT
#endif


/*
 * DEFINE FOR SIMULATION:
 * ------------------------------
 * Define on how many bytes the messageUniqueId pool will be made of
 * 1 means 1 byte means 1*8 bits means 8 possible simultaneous values
 * Maximum is 8192 since the id a long type
 */
#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACER) || defined(RTDS_FORMAT_TRACE)
	#define RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE	64

	/* Defines when tracing through socket to synchronize target execution and host debugger */
	#define RTDS_DTRACE_ACK_NOWAIT						0 	/* No acknowledgment from the host */
	#define RTDS_DTRACE_ACK_WAIT							1 	/* Ack from the host */

	#ifndef RTDS_PARAM_CODEC_MAX_DEPTH
		#define RTDS_PARAM_CODEC_MAX_DEPTH			4 	/* Number of levels when formatting message parameters to be printable in the SDL-RT debugger */
	#endif
	#ifndef RTDS_PARAM_CODEC_CHUNK_SIZE
		#define RTDS_PARAM_CODEC_CHUNK_SIZE 		128 /* Min size of memory chunk used when formatting message parameters to be printable in the SDL-RT debugger */
	#endif
#endif

/*
 * TYPE RTDS_QUEUE.ID:
 * ----------------------
 * Type for a message queue identifier
 * In OSE it is actually the pid
 */
typedef PROCESS RTDS_RtosQueueId;


/*
 * TYPE RTDS_PROCESS.ID:
 * ----------------------
 * Type for a process identifier
 * used to be int in the previous release
 */
typedef PROCESS RTDS_RtosTaskId;


/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 */
typedef SEMAPHORE *RTDS_SemaphoreId;


/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef short RTDS_SemaphoreStatus;

#define RTDS_OK 	1
#define RTDS_ERROR	0


/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef int RTDS_SemaphoreTimeout;


/*
 * TYPE RTDS_PROCESS_PRIORITY:
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;

#ifdef TO_DELETE
/*
 * STRUCT RTDS_GLOBAL.PROCESS.INFO:
 * -------------------------------
 * Type for the list of processes in the system with their information
 */
typedef struct RTDS_GlobalProcessInfo
	{
	RTDS_ProcessId              processId;					   /* The integer value of the PID */
	int                         processNumber;			 /* Name of the process as a number defined in RTDS_gen.h */
	RTDS_SdlInstanceId        * myQueueId;					   /* The message queue of the process */
	RTDS_SdlInstanceId	  					* parentQueueId;			 /* The message queue of the parent process */
	RTDS_SdlInstanceId			  			* offspringQueueId;	/* The message queue of the child process */
	int 													  sdlState; 					   /* Current SDL state of the process */
	struct RTDS_MessageHeader	* currentMessage;		 /* Last message read */
	RTDS_TimerState 							   * timerList; 				   /* Pointer to the list of current active timers */
	RTDS_MessageHeader						  * readSaveQueue; 	 	/* Save queue chained list entry point when reading saved messages */
	RTDS_MessageHeader						  * writeSaveQueue;	 	/* Save queue chained list entry point when saving messages */
	#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACE) || defined(RTDS_FORMAT_TRACE)
		RTDS_ProcessPriority				  priority; 				   	/* Priority of the process. Only used when debugging. */
	#endif
	struct RTDS_GlobalProcessInfo *next;						   	/* Next processInfo */
	} RTDS_GlobalProcessInfo;


/*
 * STRUCT RTDS_MESSAGE.HEADER:
 * ---------------------------
 * Type for a message descriptor
 */
typedef struct RTDS_MessageHeader
	{
	SIGSELECT                  sigNo;						      /* OSE specific compulsory field */
	long                       messageNumber;		  /* The integer value for the message or the timer */
	long                       timerUniqueId;		  /* If 0, normal message; otherwise unique id. for timer if message is a timer */
#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACE) || defined(RTDS_FORMAT_TRACE)
	unsigned long               messageUniqueId;	/* Used by SDL-RT debugger to trace messages */
#endif
	struct RTDS_SdlInstanceId * sender; 					    /* The message queue of the sender */
	long                        dataLength; 			  /* Length of data */
	unsigned char             * pData; 					     /* Pointer to message data */

	struct RTDS_MessageHeader 		 *next;          /* Next message if used as a message queue */
	} RTDS_MessageHeader;


#endif

/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */
#define RTDS_TIMER_OK 		1
#define RTDS_TIMER_CANCELLED	0

typedef struct RTDS_TimerState
	{
	long                        timerNumber;           /* Message number for the timer name */
	long                        timerUniqueId;         /* Timer's unique identifier among all timers */
	unsigned long               timeoutValue;          /* System tick counter value when it will go off */
	struct RTDS_SdlInstanceId * receiverSdlInstanceId; /* The message queue of the receiver */
	int                         state;                 /* State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
	unsigned long               watchDogId;            /* Id of the watchDog */

	struct RTDS_TimerState	   * next;                  /* Next timer in list */
	} RTDS_TimerState;



/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 */
typedef struct RTDS_GlobalSemaphoreInfo
	{
	RTDS_SemaphoreId								semaphoreId;			/* The semaphore address */
	int 														semaphoreNumber;	/* Semaphore number representing its name */
	struct RTDS_GlobalSemaphoreInfo *next;						/* Next semaphoreInfo */
	} RTDS_GlobalSemaphoreInfo;


#ifdef TO_DELETE
/*
 * ENUM RTDS_EVENT.TYPE:
 * -------------------------------
 * Enum of event types the SDL-RT debugger can be warned about
 */

enum RTDS_EventType
	{
	RTDS_messageSent			= 0,
	RTDS_messageReceived	= 1,
	RTDS_timerStarted 		= 2,
	RTDS_timerCancelled 	= 3,
	RTDS_processCreated 	= 4,
	RTDS_processDied			= 5,
	RTDS_semTakeAttempt 	= 6,
	RTDS_semTakeSucceded	= 7,
	RTDS_semGive					= 8,
	RTDS_sdlStateSet			= 9,
	RTDS_initDone 				= 10,
	RTDS_semTakeTimedOut	= 11,
	RTDS_systemError			= 12,
	RTDS_semaphoreCreated = 13,
	RTDS_semaphoreDeleted = 14,
	RTDS_messageSaved 		= 15
	} ;



/*
 * STRUCT RTDS_GLOBAL.TRACE.INFO:
 * -------------------------------
 * Structure containing the event information red by the SDL-RT debugger
 */
#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACER) || defined(RTDS_FORMAT_TRACE)
typedef struct RTDS_GlobalTraceInfo
	{
	enum RTDS_EventType 			event;
	void										* eventParameter1;
	long											eventParameter2;
	RTDS_GlobalProcessInfo	* currentContext;
	} RTDS_GlobalTraceInfo;

/* Global variable pointing to decoded parmaters */
extern char *RTDS_globalPrintableParameters;

#endif
#endif

#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACER) || defined(RTDS_FORMAT_TRACE)
/* Global variable pointing to decoded parmaters */
extern char *RTDS_globalPrintableParameters;
#endif
/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS \
		SIGSELECT 				sigNo;						/* OSE specific mandatory field */

/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
  RTDS_ProcessPriority priority;


