#############################################################################
# PROGRAM MODULE
#
# $Workfile:	 userconf.mk	$
# Document no: @(#) 550/OSE250-userconf
# $Revision: 2702 $
# $Author: cvs $
# $Date: 2004-10-04 12:28:19 +0200 (Mon, 04 Oct 2004) $
#
# 	Copyright (C) 1999 by OSE Systems AB. All rights reserved.
#
#############################################################################

#############################################################################
#
# Please refer to the OSE Examples & Makefiles User's Guide for more
# information on how to use this file.
#
#############################################################################

#############################################################################
#
# Configuration of OSE
#
#############################################################################
# OSEROOT: Set the path to the OSE installation directory.
# EXAMPLES_COMMON: Set the path to the common example files.
# OSE_PRODUCT_MAKEFILES: Set the path to the OSE product makefiles.
# OSE_COMPILER_MAKEFILES: Set the path to the compiler makefiles.
# OSE_BSP_ROOT: Set the path to the BSP root directory.
# The macro PLATFORM is set by the BSP selected below.

OSEROOT 		*= c:\OSE\OSE4.5.1

# EXAMPLES_COMMON is already defined in makefile.mk
# EXAMPLES_COMMON 	*= $(OSEROOT)$/examples$/common
OSE_PRODUCT_MAKEFILES *= $(OSEROOT)$/$(PLATFORM)$/makefiles$/products
OSE_COMPILER_MAKEFILES	*= $(OSEROOT)$/$(PLATFORM)$/makefiles$/compilers
OSE_BSP_ROOT		*= $(OSEROOT)$/$(PLATFORM)

#############################################################################
#
# Compiler configuration
#
#############################################################################
# Choose from the following compilers (COMPILER):
# PowerPC 	: GCC | GHS | DIAB
# ARM 		: ARM_ADS | ARM_SDT
# StrongARM 	: ARM_ADS | ARM_SDT
# MIPS		: GHS
# M68000	: DIAB
# sfk-win32 	: MSVC | GHS
# sfk-solaris2	: GCC | GHS
# sfk-linux 	: GCC
#
# COMPILERROOT defines the path to the chosen compiler.

COMPILER	*= GCC	# [ GCC | GHS | DIAB | ARM_ADS | ARM_SDT | MSVC ]

.IF $(OS) == unix
# COMPILERROOT	*= $(OSEROOT)$/solaris2
	COMPILERROOT	*= /usr/local/bin
.ELIF $(OSRELEASE) == linux
	COMPILERROOT	*=
.ELSE
	COMPILERROOT	*= $(OSEROOT)$/win32
.END

#############################################################################
#
# Selection of board
#
#############################################################################
# Choose board from:
# (See the select_cpu_and_bsp.mk file in the examples/common/make directory
# for a complete list.)
#
# PowerPC BSPs:
# 											ANY_POWERPC (load modules only)
#  [bsp-403evb]:
# 		IBM_403EVB
#  [bsp-walnut]:
# 		IBM_WALNUT
#  [bsp-ibc603]:
# 		FORCE_IBC603
#  [bsp-mvme2600]:
# 		MOTOROLA_MVME2300
# 		MOTOROLA_MVME2600-1
# 		MOTOROLA_MVME2600-2
# 		MOTOROLA_MVME3600-1
# 		MOTOROLA_MVME3600-2
# 		MOTOROLA_MVME2700-1
# 		MOTOROLA_MVME2700-2
#  [bsp-powercore]:
# 		FORCE_POWERCORE
#  [bsp-mpc8260]:
# 		EST_SBC8260
# 		MOTOROLA_VADS8260
#  [bsp-powercore6750]:
# 		FORCE_POWERCORE-6750
#  [bsp-mcp750]:
# 		MOTOROLA_MCP750
# 		MOTOROLA_MCPN750
#  [bsp-yk750]:
# 		MOTOROLA_YK750
#  [bsp-mpc8xx]:
# 		EST_SBC821
# 		MOTOROLA_ADS821
# 		MOTOROLA_MBX821
# 		EMBEDDEDPLANET_RPXLITE
# 		EST_MDP860
# 		EST_MDP860P
# 		EST_SBC860
# 		MOTOROLA_MBX860
# 		MOTOROLA_ADS860
# 		MOTOROLA_FADS860T
# 		PEP_VSBC860
#  [bsp-est8240]:
# 		EST_SBC8240
#  [bsp-sandpoint]:
# 		MOTOROLA_SANDPOINT7400
# 		MOTOROLA_SANDPOINT755
# 		MOTOROLA_SANDPOINT8240
#
# M68000 BSPs:
# 											ANY_M68000 (load modules only)
#  [bsp-sbc360]:
# 		EST_SBC360
#  [bsp-fads302]:
# 		MOTOROLA_FADSEN302
# 		MOTOROLA_FADSLC302
#
# ARM BSPs:
# 											ANY_ARM_LE (load modules only)
# 											ANY_ARM_BE (load modules only)
#  [bsp-integrator]
# 		ARM_INTEGRATOR_7_LE
# 		ARM_INTEGRATOR_720_LE
# 		ARM_INTEGRATOR_9_LE
# 		ARM_INTEGRATOR_920_LE
#  [bsp-coyanosa]
# 		INTEL_IQ80310EV_LE
#
# StrongARM BSPs:
# 											ANY_SARM_LE (load modules only)
#  [bsp-sa1110]:
# 										INTEL_SA1110_LE
#  [bsp-ixp1200]:
# 		INTEL_IXP1200EV_LE
#
# Solaris2 BSPs:
#
#  [bsp-sunsfk]:
# 		SOLARIS2
#
# Linux BSPs:
#
#  [bsp-linuxsfk]:
# 		LINUX
#
# Win32 BSPs:
#
#  [bsp-win32sfk]:
# 		WIN32
#
# MIPS BSPs:
#
#  [bsp-rc36100]:
# 		IDT_RC36100
#  [bsp-tmpr3904]:
# 		TOSHIBA_TMPR3904
#

BOARD 	*= WIN32


# If you want to use a contributed BSP, i.e. one of the BSPs in
# $(OSEROOT)$/contrib, or if you want to use your own BSP, you must NOT
# define the parameter BOARD, but define the following parameters instead:

# BOARD 	*=
# BSPROOT = <my_bsp_root>
# BSPMAKE = $(BSPROOT)$/conf$/<my_bsp_makefile>
# PLATFORM	= <platform, e.g. powerpc>
# PROCESSOR = <processor, e.g. 860>

# Setting the parameter CALL_BSP_START_HANDLER_1 to "no"
# will result in bspStartHandler1 not being called.

CALL_BSP_START_HANDLER_1 *= yes # [ yes | no ]

#############################################################################
#
# Memory configuration
#
#############################################################################
# IMAGE_START specifies where the text segment of the image shall start.
# IMAGE_START + IMAGE_MAX_LENGTH specify the maximum image end address.
# Note: When using an application running before the OSE monolith
# (e.g. OSE Boot Loader or POLO) change IMAGE_START and IMAGE_MAX_LENGTH to
# avoid conflicts.

IMAGE_START 		 *= 0x20000 # Only valid for PowerPC and M68000 monoliths
IMAGE_MAX_LENGTH *= 0x3E0000

#############################################################################
#
# Optimizations
#
#############################################################################
# OPTIMIZE_FOR safety generates debug information, debug system calls,
# krn1dpr kernel (PowerPC, ARM, StrongARM, MIPS), krn2dpx kernel (M68000),
# softose kernel (SFK), OS<arch> configuration (DEBUG(YES), ERROR_CHECKS(2),
# MEMORY_MODEL(1)).
# OPTIMIZE_FOR speed generates optimized code, krn0xxx kernel, softose kernel
# (SFK), OS<arch> configuration (DEBUG(NO), ERROR_CHECKS(0), MEMORY_MODEL(0)).
# DISABLE_FLOATING_POINT disables floating point support in the compiler.

OPTIMIZE_FOR		*= safety # [ safety | speed ]
DISABLE_FLOATING_POINT	*= no 	# [ yes | no ]

#############################################################################
#
# Source code debugger configuration
#
#############################################################################
# Define which source code debugger to make the debug information for.
# ghs  - Green Hills debug information (supported when using GHS compiler).
# sds  - SDS-compatible debug information (supported when using DIAB
# 			 compiler).
# hsi  - HSI Vision[Click|XD] debug information and download file conversion
# 			 (don't forget to configure the path to the HSI root and converter).
# xray - XRay debug information (supported when using GCC compiler).
# no	 - No debug information.

SOURCE_CODE_DEBUGGER *= no	# [ ghs | sds | hsi | xray | no ]

.IF $(SOURCE_CODE_DEBUGGER) == hsi
	.IF $(OS) == unix
		HSI_ROOT	*= /usr/central/visionXD/Solaris/bin
		CONVERT *= $(HSI_ROOT)$/convert
	.ELSE
		HSI_ROOT	*= D:\estii_7.5a
		CONVERT *= $(HSI_ROOT)$/convert.exe
	.END
.END

#############################################################################
#
# Executable file type options
#
#############################################################################
# The executable file type is used to specify if a monolith or a load module
# is to be built.
# Note: Currently, only the cplusplus_lm, hello_world_lm, othello_lm,
# surfer_lm, and tutorial_lm examples are guaranteed to work when built as
# load modules. Trying to build the other examples as load modules may not
# work since all examples cannot be built as load modules or have not been
# tested for this.
# MAKE_SREC_FILE specify if a srecord file shall be created after linking.
# MAKE_BINARY_FILE specify if a binary file shall be created after linking.

EXECUTABLE_FILE_TYPE	*= monolith 	# [ monolith | load_module ]

MAKE_SREC_FILE		*= no 	# [ yes | no ]
MAKE_BINARY_FILE	*= no 	# [ yes | no ]


#############################################################################
#
# OBJ sub-directory
#
#############################################################################
# OBJ_SUBDIR specifies where to put the result of the build (object files,
# configuration files, monoliths, load modules and so on).
# EXECUTABLE_DIR points to the directory where the executable file(s) and the
# debug information file(s) are placed.

OBJ_SUBDIR	*:= $(BOARD)

EXECUTABLE_DIR	*:= ..$/obj$/$(OBJ_SUBDIR)

#############################################################################
#
# OSE product configuration options
#
#############################################################################
# Any of the following OSE products can be excluded if you are not planning
# to use them or if you need to save resources.
# Note, many products depend on other products and these dependencies may not
# be detected by the example make system. There may be failures to compile or
# link or runtime errors as a result. Refer to the product manuals to make
# sure the product dependencies are resolved.
#
# Debug selections are gathered together in the debugging section below.

#############################################################################
#
# Configuration of OSE Board Support Package (BSP)
#
#############################################################################
# This configuration defines if a BSP is to be used in the monolith or not.
# A BSP is always needed for monoliths except in some SFK systems that do not
# require device drivers.
# SKIP_CACHE should be set to yes if MMS is used. When SKIP_CACHE is set to
# yes the cache initialisation done by the BSP is turned off. This means that
# the MMS can control the cache handling using the MMU. Cache handling
# options is then configured in the MMS configuration file (mms.con). If MMS
# is not used and SKIP_CACHE is set to yes no cache is used in the system.
# When using an OSE 4.2 style makefile for your BSP make sure to define
# USE_4_2_BSP = yes to enable the OSE 4.2 BSP makefile mode.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# Supported architectures: All
# Supported builds: Monolith, Boot Loader

INCLUDE_OSE_BSP 	*= yes		# [ yes | no ]

.IF $(INCLUDE_OSE_BSP) == yes
	SKIP_CACHE		*= no 		# [ yes | no ]
	USE_4_2_BSP 	*= no 	# [ yes | no ]
.END

#############################################################################
#
# Configuration of OSE Bluetooth Host Stack
#
#############################################################################
# Adds the Bluetooth host stack to the system.
# SERVER_ADDR specifies the Bluetooth server address.
# BLUETOOTH_PORT specifies which port to communicate with the Bluetooth
# module on.
#
# Dependencies: INCLUDE_OSE_BSP = yes
# 	INCLUDE_OSE_KERNEL = yes
# Supported architectures: PowerPC, ARM, StrongARM, sfk-win32
# Supported builds: Monolith

INCLUDE_OSE_BLUETOOTH *= no # [ yes | no ]

.IF $(INCLUDE_OSE_BLUETOOTH) == yes
	# Specify the Bluetooth server address
	SERVER_ADDR 	*= 0x00,0xd0,0xb7,0x03,0x0e,0x5e
	USE_SER 	*= yes	# [ yes | no ] Enable serial device driver
	BLUETOOTH_PORT	*= com1 # [ com1 | com2 ]
.END

#############################################################################
#
# C++ options
#
#############################################################################
# Includes C++ support in the system.
# USE_C_PLUS_PLUS_EXCEPTIONS defines if C++ exceptions is needed by the
# application.
# USE_C_PLUS_PLUS_STL defines if the Standard Template Library is needed by
# the application.
# Note: All C++ features are not supported on all architectures or compilers.
# See the relevant C++ manual for restrictions.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# Supported architectures: PowerPC, SFK
# Supported builds: Monolith, Load Module

INCLUDE_OSE_C_PLUS_PLUS 	*= no # [ yes | no ]

.IF $(INCLUDE_OSE_C_PLUS_PLUS) == yes
	USE_C_PLUS_PLUS_EXCEPTIONS	*= no # [ yes | no ]
	USE_C_PLUS_PLUS_STL 		*= no # [ yes | no ]
.END

#############################################################################
#
# Configuration of OSE Debugging Products
#
#############################################################################
# INCLUDE_OSE_DEBUG enables the OSE debugging features in the system.
# USE_SIGDB creates a sigdb signal table for Illuminator debugging of signal
# traces.
# USE_SDM enables source code runmode debugging in the system. The SDM is
# only available for PowerPC and ARM.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_INET = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_DEBUG *= yes # [ yes | no ] Requires INET or SFK

.IF $(INCLUDE_OSE_DEBUG) == yes
	USE_SIGDB 				*= yes	# [ yes | no ]
	USE_SDM 		*= no # [ yes | no ] Only available for PowerPC and ARM
.END

#############################################################################
#
# Dbgprintf settings
#
#############################################################################
# INCLUDE_OSE_DBGPRINTF specifies if dbgprintf is to be included in the
# system. Load modules may use the access part of dbgprintf if the server
# part is located in the system in another load module or the monolith.
#
# DBGPRINTF_PORT specifies which media to dbgprintf to. The following medias
# are available:
# com1, com2	- Dbgprintf to the specified serial port.
# eth 	- Dbgprintf using raw ethernet
# 								(requires no INET on the same ethernet interface).
# udp 	- Dbgprintf using INET UDP communication.
# native	- Dbgprintf to the native host terminal (SFK only).
# sds 	- Dbgprintf to SDS debugger i/o window.
# ghs 	- Dbgprintf to GHS debugger i/o window.
# access				- Access part of dbgprintf if load module.
# silent	- Ignore all dbgprintf calls.
#
# DBGPRINTF_UDPPORT specifies which UDP port to use when DBGPRINTF_PORT is
# set to udp or eth.
# If DBGPRINTF_PORT is set to eth you also have to specify the ethernet
# address (ETH_ADDR *= <eth_addr>).
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							if udp:
# 							INCLUDE_OSE_INET = yes
# 							if eth, com1, or com2:
# 							INCLUDE_OSE_BSP = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_DBGPRINTF *= yes	# [ yes | no ]

.IF $(INCLUDE_OSE_DBGPRINTF) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_DBGPRINTF *= access # [ access | server ]

	DBGPRINTF_PORT *= native	# [ com1|com2|eth|ghs|native|silent|udp|sds ]

	.IF $(DBGPRINTF_PORT) == udp
		DBGPRINTF_UDPPORT *= 50011
	.END

	.IF $(DBGPRINTF_PORT) == eth
		DBGPRINTF_UDPPORT *= 50011
		ETH_ADDR *= 0x1a,0x14,0x18,0x17,0x19,0x16
	.END
.END

#############################################################################
#
# Configuration of OSE DHCP Server (DHCPS)
#
#############################################################################
# Adds the DHCP server to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_INET = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_DHCPS *= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE DNS Server
#
#############################################################################
# Adds the DNS server to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_EFS = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_DNS_SERVER	*= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE Atomic File Manager (AFM)
#
#############################################################################
# Adds AFM to the system.
# AFM has one server and one access part. In a system using AFM there must be
# one server. The access part is used to access AFM functionality from load
# modules.
# INCLUDE_AFM_CMDS adds the AFM-specific shell commands to the shell.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_TOSV = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_AFM 		*= no # [ yes | no ]

.IF $(INCLUDE_OSE_AFM) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_AFM	*= access # [ access | server ]

	INCLUDE_AFM_CMDS		*= yes	# [ yes | no ]
.END

#############################################################################
#
# Configuration of OSE Embedded File System (EFS)
#
#############################################################################
# Adds EFS to the system.
# EFS has one server and one access part. In a system using EFS there must be
# one server. The access part is used to access EFS functionality from load
# modules.
# INCLUDE_EFS_CMDS adds the EFS-specific shell commands to the shell.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_TOSV = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_EFS 		*= no # [ yes | no ]

.IF $(INCLUDE_OSE_EFS) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_EFS	*= access # [ access | server ]

	INCLUDE_EFS_CMDS		*= yes	# [ yes | no ]
.END

#############################################################################
#
# Configuration of OSE Flash FX (FFX)
#
#############################################################################
# Adds Flash FX to the system.
# Flash FX is used when you would like to use a flash array as your physical
# file system storage media. When including Flash FX you also have to specify
# which fim (Flash Interface Module) you would like to use. For a reference
# of available fims, please refer to the Flash FX documentation or the Flash
# FX fim source directory. You can also simulate a fim by placing the "flash"
# in your target RAM. This is done by setting FIMTYPE to osefimram.
# If you would like to test a new fim you can set TESTOEM to yes. This will
# exercise the oem layer through the fim to see if it works as it should.
# The testoem tool is implemented as an OSE shell command. Testoem is a
# stand-alone application that operates without the inclusion of the DDB.
# REMEMBER that you will have to do modifications to oemconf.h and machine.h
# to match your target. Especially when changing FIMTYPE you need to define
# the selected fim in oemconf.h.
# If you would like to add your own fim you also need to add it to
# oemflash.c. Please refer to the Flash FX documentation for a reference.
# If you need to change your partition size you need to edit the size
# information in the lpThisMedia pointer located in the fim. You also need
# to configure the FFX_FMT_SIZE parameter located in ose_ddb.c.
# It is not recommended to use caches with Flash FX, set SKIP_CACHE to yes
# in the BSP configuration if Flash FX is used.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_TOSV = yes
# 							INCLUDE_OSE_EFS = yes
# Supported architectures: PowerPC, ARM, StrongARM
# Supported builds: Monolith, Load Module

INCLUDE_OSE_FFX 	*= no # [ yes | no ]

.IF $(INCLUDE_OSE_FFX) == yes
 # Setup for MOTOROLA_MBX860 with fim amd29f080 in quad configuration
 FIMTYPE		*= oseamd4x8
 TESTOEM		*= no # [ yes | no ]
 FFX_PARTITION_START	*= 0xFC000000
.END

#############################################################################
#
# Configuration of OSE SNMP Emanate Full/Lite
#
#############################################################################
# Adds SNMP Emanate Full or Lite to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_INET = yes
# 							INCLUDE_OSE_PTHREAD = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_EMANATE_FULL	*= no # [ yes | no ]
INCLUDE_OSE_EMANATE_LITE	*= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE FastJ
#
#############################################################################
# Adds FastJ to the system.
# FASTJ_GARBAGE_COLLECTOR specifies which type of garbage collector FastJ
# will use.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_HEAP = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_EFS = yes
# 							INCLUDE_OSE_INET = yes
# 							INCLUDE_OSE_PTHREAD = yes
# 	COMPILER = DIAB
# Supported architectures: PowerPC
# Supported builds: Monolith

USE_FASTJ 		*= no # [ yes | no ]

.IF $(USE_FASTJ) == yes
	FASTJ_GARBAGE_COLLECTOR *= block # [ block | simple ]
.END

#############################################################################
#
# Configuration of OSE Heap Manager (HEAP)
#
#############################################################################
# Adds the heap manager to the system.
# The size of the heap is set with HEAP_SIZE. The predefined sizes can be
# found in the heapcon.c file. Other sizes can be used but the predefined
# sizes are defined to minimize fragmentation.
# HEAP_SHARE_MODE sets the heap in either shared or private mode. Shared mode
# lets the allocated buffers be shared among processes in the same segment.
# Private mode sets all buffers to be private to the process allocating them.
# Note: When building load modules, you can't include only the access part of
# the heap. Each segment must have its own heap.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_HEAP		*= yes		# [ yes | no ]

.IF $(INCLUDE_OSE_HEAP) == yes
	HEAP_SHARE_MODE 		*= no 	# [ yes | no ]
	HEAP_SIZE 		*= SIZE_276K
.END

#############################################################################
#
# Configuration of OSE Internet Protocols (INET)
#
#############################################################################
# Adds INET to the system.
# INET has one server and one access part. In a system using INET there must
# be one server. The access part is used to access INET functionality from
# load modules.
# INET sets which INET stack connection to use
# (OSE = OSE INET stack, api = the host stack in a SFK system).
# USE_ETH adds ethernet support to the system. The value sds shall be set
# when using SDS freeze mode debugging via ethernet.
# ETH_ADDR sets the ethernet MAC address of the system.
# ETH_IP_ADDR sets the IP address of the system.
# USE_ETH2 adds ethernet support for a second ethernet unit in the system.
# ETH_ADDR2 sets the ethernet MAC address of the second ethernet unit in the
# system.
# ETH_IP_ADDR2 sets the IP address of the second ethernet unit in the system.
# ETH_SUBNETMASK sets the subnet mask of the network used for ethernet.
# PPP_SERIAL_PORT adds PPP support to the system.
# PPP_BAUDRATE sets the baudrate of the PPP connection.
# PPP_IP_ADDR sets the IP address of the PPP connection.
# PPP_REMOTE_IP_ADDR sets the remote IP address of the PPP connection.
# PPP_SUBNETMASK sets the subnet mask of the network used for PPP.
# DEFAULT_GATEWAY sets the IP address of the gateway used by the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_BSP = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_INET	*= yes # [ yes | no ]

.IF $(INCLUDE_OSE_INET) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_INET *= access # [ access | server ]


	INET			*= api	# [ no | api | OSE ]

	# Ethernet MAC address and IP address
	USE_ETH 	*= no  # [ no | yes | sds ]
	#ETH_ADDR 	 *= 0x1a,0x14,0x18,0x1e,0xaa,0x16
	#ETH_IP_ADDR	 *= 192.168.10.69
	ETH_IP_ADDR 	*= 192.168.1.20

	# Second ethernet MAC address and IP address
	USE_ETH2		*= no # [ yes | no ]
	ETH_ADDR2 	*= 0x1a,0x14,0x18,0x17,0x19,0x16
	ETH_IP_ADDR2		*= 192.168.1.100

	# PPP baudrate, IP address, and remote IP address
	PPP_SERIAL_PORT *= no # [ no | com1 | com2 ]
	PPP_BAUDRATE		*= 38400
	PPP_IP_ADDR 	*= 136.36.4.12
	PPP_REMOTE_IP_ADDR	*= 136.36.4.13

	# Ethernet subnet mask, PPP subnet mask, and gateway IP address
	ETH_SUBNETMASK	*= 255.255.255.0
	PPP_SUBNETMASK	*= 255.255.255.0
	DEFAULT_GATEWAY *= 192.168.10.254
.END

#############################################################################
#
# Configuration of OSE Internet Utilities (INETUTIL)
#
#############################################################################
# Adds INETUTIL to the system.
# The access part is used in load modules to access the server part located
# in the monolith or in another preloaded load module.
#
# The utilities included by INCLUDE_OSE_INETUTIL are:
# DHCP Client
# Disable by adding the line "DISABLE_DHCP_CLIENT *= yes"
# FTP Server
# Disable by adding the line "DISABLE_FTP_SERVER *= yes"
# FTP Client
# Disable by adding the line "DISABLE_FTP_CLIENT *= yes"
# TFTP Server
# Disable by adding the line "DISABLE_TFTP_SERVER *= yes"
# Interactive and non-interactive TFTP Client
# Disable by adding the line "DISABLE_TFTP_CLIENT *= yes"
# Telnet Server
# Disable by adding the line "DISABLE_TELNET_SERVER *= yes"
# OSE Surfer
# Disable by adding the line "DISABLE_OSE_SURFER *= yes"
# DNS Client
# Disable by adding the line "DISABLE_DNS_CLIENT *= yes"
# 			DNS_IP_ADDR specifies the IP address of the DNS server
# 			DNS_DOMAIN specifies the DNS domain name
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_RTC = yes
# 							INCLUDE_OSE_EFS = yes
# 							INCLUDE_OSE_INET = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_INETUTIL	*= no # [ yes | no ]

.IF $(INCLUDE_OSE_INETUTIL) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_INETUTIL *= access # [ access | server ]


	.IF $(DISABLE_DNS_CLIENT) != yes
		DNS_IP_ADDR 	*= 172.19.1.1
		DNS_DOMAIN		*= .enea.se
	.END
.END

#############################################################################
#
# Configuration of OSE Kernel
#
#############################################################################
# INCLUDE_OSE_KERNEL defines if the kernel is to be used in the system.
# This option must be yes for both monoliths and load modules.
# START_STACK adds a number of bytes to the OSE start stack.
# SUPERV_SIZE adds supervisor stack to all processes in the system.
# SYSTEM_TIMER configures the kernel system timer.
# POOL_SIZE specifies the pool size of the system.
# MAX_ATTACHED specifies the maximum number of processes attached in the
# system.
#
# Dependencies: None
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_KERNEL	*= yes	# [ yes | no ]

.IF $(INCLUDE_OSE_KERNEL) == yes
	# Default values:
	MAX_ATTACHED	*= 256
	START_STACK 	*= 0		# Size in bytes
	POOL_SIZE 	*= 0x100000 # Size in bytes
	SUPERV_SIZE 	*= 0		# Size in bytes
	#SYSTEM_TIMER *= 4		# Ms/tick (default value is set in
				# <arch>/makefiles/products/kernel.mk)
.END

#############################################################################
#
# Configuration of OSE Link Handler (LNH)
#
#############################################################################
# Adds the link handler to the system.
# LNH_INTERFACE specifies the type of link handler protocol driver (PDR) to
# use. The possible values are:
# udp 			 - Link handler over udp (UDPPDR).
# 						 Requires INCLUDE_OSE_INET to be set to yes.
# eth 			 - Link handler over raw ethernet (ETHPDR).
# 						 Requires INCLUDE_OSE_INET to be set to no.
# com1, com2 - Link handler over serial (SERPDR).
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 							INCLUDE_OSE_BSP = yes
# 							INCLUDE_OSE_TOSV = yes
# 							if udp link handler:
# 							INCLUDE_OSE_INET = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_LNH 	*= no # [ yes | no ]

LNH_INTERFACE 				*= com1 # [ com1 | com2 | udp | eth ]

#############################################################################
#
# Configuration of OSE Memory Management System (MMS)
#
#############################################################################
# INCLUDE_OSE_MMS defines if the MMS is to be used in the system.
# The yes option is used to include the MMS (full memory management). The mmh
# option is used to include the MMH (emulated memory management) instead of
# the MMS. The no option is used to exclude memory management.
# SKIP_CACHE in the BSP configuration should be set to yes if MMS is used.
# Note: If M68000 is used only the MMH is supported.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# Supported architectures: PowerPC, M68000, ARM, StrongARM
# Supported builds: Monolith

INCLUDE_OSE_MMS 	*= no 			# [ yes | no | mmh ]

#############################################################################
#
# Configuration of OSE Name Server
#
#############################################################################
# Adds the name server to the system.
# SYSTEM_NAME is used to define a system name for the block of the name
# server process oseSystemServer.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_LNH = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_OSENS *= no # [ yes | no ]

.IF $(INCLUDE_OSE_OSENS) == yes
	SYSTEM_NAME 			*=
.END

#############################################################################
#
# Configuration of OSE Network Time Protocol (NTP)
#
#############################################################################
# Adds NTP to the system.
# The NTP_OR_SNTP variable specifies which NTP type to use.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_TOSV = yes
# 	INCLUDE_OSE_HEAP = yes
# 	INCLUDE_OSE_RTC = yes
# 				one of the following:
# 	INCLUDE_OSE_INET = yes
# 	or
# 	INCLUDE_OSE_LNH = yes
# 	or
# 	INCLUDE_OSE_OSENS = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_NTP 	*= no # [ yes | no ]

.IF $(INCLUDE_OSE_NTP) == yes
	NTP_OR_SNTP 	*= ntp	# [ ntp | sntp ]
.END

#############################################################################
#
# Configuration of OSE OSPF
#
#############################################################################
# Adds OSPF to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_INET = yes
# 							if persistent storage is needed:
# 	INCLUDE_OSE_EFS = yes
# 							if web configuration is used:
# 	INCLUDE_OSE_WEBS = yes
# 				if SNMP configuration is used:
# 	INCLUDE_OSE_EMANATE_LITE = yes
# 							or
# 	INCLUDE_OSE_EMANATE_FULL = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_OSPF *= no	# [ yes | no ]

#############################################################################
#
# Configuration of OSE Personal JRuntime
#
#############################################################################
# Adds PersonalJava to the system.
# USE_GRAPHICS adds graphics support to the system.
# USE_TOUCHSCREEN adds touch screen support to the system.
# USE_MOUSE adds mouse support to the system.
# USE_KEYBOARD adds keyboard support to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_BSP = yes
# 	INCLUDE_OSE_TOSV = yes
# 	INCLUDE_OSE_RTC = yes
# 	INCLUDE_OSE_HEAP = yes
# 	INCLUDE_OSE_EFS = yes
# 	INCLUDE_OSE_SHELL = yes
# 	INCLUDE_OSE_INET = yes
# 	INCLUDE_OSE_INETUTIL = yes
# Supported architectures: PowerPC, sfk-solaris2, sfk-linux
# Supported builds: Monolith

INCLUDE_OSE_PJAVA *= no # [ yes | no ]

.IF $(INCLUDE_OSE_PJAVA) == yes
	USE_GRAPHICS		*= no 	# [ yes | no ]
	USE_TOUCHSCREEN *= no 	# [ yes | no ]
	USE_MOUSE 	*= no 	# [ yes | no ]
	USE_KEYBOARD		*= no 	# [ yes | no ]

	# Configure where the Java Development Kit is located
	.IF $(OS) == unix
		JDKROOT *= /usr/local/java/java1.1
	.ELIF $(OSRELEASE) == linux
		JDKROOT *=
	.ELSE
		JDKROOT *= C:\java\java1.1
	.END
.END

#############################################################################
#
# Configuration of OSE Post Mortem Debugger (PMD)
#
#############################################################################
# Adds the PMD to the system.
# PMD_AREA_SIZE specifies the size of the area reserved for PMD dumps.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_EFS = yes
# 	INCLUDE_OSE_ZLIB = yes
# Supported architectures: PowerPC
# Supported builds: Monolith

INCLUDE_OSE_PMD 	*= no # [ yes | no ]

.IF $(INCLUDE_OSE_PMD) == yes
	PMD_AREA_SIZE 	*= 0x80000
.END

#############################################################################
#
# Configuration of OSE Program Handler (PRH)
#
#############################################################################
# Adds the PRH to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_RTC = yes
# 	INCLUDE_OSE_TOSV = yes
# 	INCLUDE_OSE_HEAP = yes
# 	INCLUDE_OSE_EFS = yes
# 	INCLUDE_OSE_INET = yes
# 	INCLUDE_OSE_INETUTIL = yes
# 	INCLUDE_OSE_ZLIB = yes
# 	INCLUDE_OSE_MMS = yes | mmh
# Supported architectures: PowerPC, M68000, ARM, StrongARM
# Supported builds: Monolith

INCLUDE_OSE_PRH 	*= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE Pthreads
#
#############################################################################
# Adds pthreads (POSIX threads) support to the system.
# For each segment using pthreads there must be a local instance of the
# pthreads library, i.e. include pthreads for all load modules using pthreads
# functionality.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_RTC = yes
# 	INCLUDE_OSE_HEAP = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_PTHREAD *= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE Real Time Clock (RTC)
#
#############################################################################
# Adds RTC to the system.
# RTC has one server and one access part. In a system using RTC there must be
# one server (in the monolith). The access part is used to access RTC
# functionality from load modules.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_RTC 		*= yes # [ yes | no ]

.IF $(INCLUDE_OSE_RTC) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_RTC	*= access # [ access | server ]
.END

#############################################################################
#
# Configuration of OSE Routing Information Protocol (RIP)
#
#############################################################################
# Adds RIP to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_INET = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_RIP *= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE Shell
#
#############################################################################
# Adds the shell to the system.
# Shell has one server and one access part. In a system using shell there
# must be one server. The access part is used to access shell functionality
# from load modules.
# SHELL_SERIAL_PORT specifies which serial port to use. The option terminal
# can only be used in SFK systems.
# INCLUDE_SHELL_CMDS specifies if the shell commands shall be included in the
# system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_RTC = yes
# 	INCLUDE_OSE_TOSV = yes
# 	INCLUDE_OSE_HEAP = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_SHELL 	*= no 	# [ yes | no ]

.IF $(INCLUDE_OSE_SHELL) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_SHELL *= access	# [ access | server ]

	SHELL_SERIAL_PORT 	*= terminal 	# [ com1 | com2 | terminal | no ]
	INCLUDE_SHELL_CMDS		*= yes		# [ yes | no ]
.END

#############################################################################
#
# Configuration of OSE Time Out Server (TOSV)
#
#############################################################################
# Adds TOSV to the system.
# TOSV has one server and one access part. In a system using TOSV there must
# be one server (in the monolith). The access part is used to access TOSV
# functionality from load modules.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# Supported architectures: All
# Supported builds: Monolith, Load Module

INCLUDE_OSE_TOSV		*= yes # [ yes | no ]

.IF $(INCLUDE_OSE_TOSV) == yes
	# Only relevant when building load module
	LOAD_MODULE_INCLUSION_OF_TOSV *= access # [ access | server ]
.END

#############################################################################
#
# Configuration of OSE Trillium SSI
#
#############################################################################
# Adds Trillium to the system.
# USE_TRILLIUM_SSI_TEST enables the Trillium SSI tests.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_RTC = yes
# Supported architectures: PowerPC, SFK
# Supported builds: Monolith

INCLUDE_OSE_TRILLIUM	*= no # [ yes | no ]

.IF $(INCLUDE_OSE_TRILLIUM) == yes
	USE_TRILLIUM_SSI_TEST *= yes	# [ yes | no ]
.END

#############################################################################
#
# Configuration of OSE WAP Server
#
#############################################################################
# Adds the WAP server to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_INET = yes
# 	INCLUDE_OSE_HEAP = yes
# Supported architectures: PowerPC, sfk-solaris2, sfk-win32
# Supported builds: Monolith

INCLUDE_OSE_WAP 	*= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE Web Server (WEBS)
#
#############################################################################
# Adds the web server to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_BSP = yes
# 	INCLUDE_OSE_RTC = yes
# 	INCLUDE_OSE_EFS = yes
# 	INCLUDE_OSE_INET = yes
# 	INCLUDE_OSE_INETUTIL = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_WEBS	*= no # [ yes | no ]

#############################################################################
#
# Configuration of OSE ZLIB
#
#############################################################################
# Adds zlib support to the system.
#
# Dependencies: INCLUDE_OSE_KERNEL = yes
# 	INCLUDE_OSE_HEAP = yes
# Supported architectures: All
# Supported builds: Monolith

INCLUDE_OSE_ZLIB	*= no # [ yes | no ]

