/* PragmaDev RTDS Nucleus integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* NUCLEUS headers */
#include "plus/nucleus.h"

#include "stdio.h"
#include "stdlib.h"

/* RTDS includes */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

/* The system memory pool for memory allocation */
extern NU_MEMORY_POOL System_Memory;

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
extern RTDS_GlobalProcessInfo * RTDS_globalProcessInfo;
extern RTDS_GlobalProcessInfo * RTDS_globalProcessInfoToDelete;
extern RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo;

#ifdef RTDS_SIMULATOR
    extern unsigned char * RTDS_globalMessageUniqueIdPool;
    extern RTDS_GlobalTraceInfo RTDS_globalTraceEntry;
    /* Global variable pointing to decoded parmaters */
    extern char * RTDS_globalPrintableParameters;
    extern unsigned long RTDS_globalSystemTime;
#endif

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */

/* Timer and alarm operations */
extern long RTDS_GetTimerUniqueId( RTDS_TimerState * );
extern void RTDS_WatchDogFunction( UNSIGNED );
extern void RTDS_StartTimer( RTDS_SdlInstanceId *, long, long, int, RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void RTDS_StopTimer( long, RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern unsigned long RTDS_GetSystemTime( void );

/* Queue and message operations */
extern RTDS_RtosQueueId RTDS_MsgQueueCreate( void );
extern void RTDS_MsgQueueSend( long, long, unsigned char *, RTDS_SdlInstanceId *, RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * );
extern void RTDS_MsgReceive( RTDS_SdlInstanceId *, RTDS_MessageHeader ** );
extern int RTDS_MsgQueueReceive( RTDS_RtosQueueId, RTDS_MessageHeader **, int, int );
extern RTDS_SdlInstanceId * RTDS_GetProcessInstanceId( int processNumber );

/* Task and process operations */
extern RTDS_RtosTaskId RTDS_TaskCreate( int, VOID ( * functionAddress )( UNSIGNED, VOID * ), void * );
extern void RTDS_ProcessCreate( char *, int, VOID ( * functionAddress )( UNSIGNED, VOID * ), int, short, RTDS_GlobalProcessInfo * );
extern RTDS_RtosTaskId RTDS_ProcessForget( RTDS_GlobalProcessInfo * );
extern void RTDS_ProcessKill( RTDS_GlobalProcessInfo * );
extern NU_TASK * RTDS_GetActiveThread( void );

/* Semaphore operations */
extern void RTDS_Sem_Delete( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake( RTDS_SemaphoreId, RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId RTDS_GetSemaphoreId( int semaphoreNumber );
extern RTDS_SemaphoreId RTDS_Sem_Info_Insert( int, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId RTDS_Semaphore_Create( char *, OPTION, int );
extern void RTDS_SemaphoreIdGive( RTDS_SemaphoreId );

/* Memory operations */
extern void RTDS_Free( VOID * );
extern VOID * RTDS_Malloc( UNSIGNED );
extern void RTDS_TransitionCleanUp( RTDS_GlobalProcessInfo *, int );
extern void * memcpy( void *, const void *, size_t );

/* Main fonction */
extern VOID RTDS_Start( UNSIGNED, VOID * );

/* External NUCLEUS function declarations */
extern VOID ERC_System_Error( INT );
extern void Application_Initialize( void * );

#ifdef RTDS_SIMULATOR
        extern unsigned long RTDS_GetMessageUniqueId( void );
        extern void RTDS_ReleaseMessageUniqueId( unsigned long );
        extern void RTDS_DummyTraceFunction( void );
        extern void RTDS_messageDataToString( char **, long, long, void *, int );
        extern char * RTDS_stringToMessageData( long, long *, void **, char * );
        extern void RTDS_SimulatorMsgQueueSend( long, long, unsigned char *, RTDS_SdlInstanceId *, RTDS_SdlInstanceId *, long );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
