/* PragmaDev RTDS Nucleus integration */
#include "RTDS_MACRO.h"
#include "../trace/backtrace/RTDS_BackTrace.h"
#include "RTDS_gen.h"

#define RTDS_PROCESS_NUMBER RTDS_process_RTDS_Env
#define RTDS_PROCESS_NAME RTDS_Env

/*
 * FUNCTION FOR PROCESS RTDS_Env:
 * ------------------------------
 */

RTDS_TASK_ENTRY_POINT( RTDS_Env )
    {
    RTDS_GlobalProcessInfo * RTDS_currentContext = NULL;
    
    /* Before trying to retrieve information pass to the argv parameter */
    /* We have to check if the number of argument equals RTDS_TASK_OPTIONS_NUMBER */
    if ( option != RTDS_TASK_OPTIONS_NUMBER )
        {
        RTDS_SYSTEM_ERROR( RTDS_ERROR_TASK_OPTIONS_NUMBER );
        }
    RTDS_currentContext = ( RTDS_GlobalProcessInfo * )pointer;
    
    RTDS_SDL_STATE_SET( RTDS_state_RTDS_Idle );
    
    /* Event loop */
    for ( ; ; )
        {
        /* Get message from process's message queue */
        RTDS_currentContext->currentMessage = ( RTDS_MessageHeader * )RTDS_MALLOC( sizeof( RTDS_MessageHeader ) );
        RTDS_MSG_QUEUE_READ( RTDS_currentContext->currentMessage );
        RTDS_currentContext->currentMessage->next = NULL;
        
    #ifdef RTDS_SIMULATOR
        RTDS_messageDataToString
        ( &RTDS_globalPrintableParameters,
         RTDS_currentContext->currentMessage->messageNumber,
         RTDS_currentContext->currentMessage->dataLength,
         ( void * )( RTDS_currentContext->currentMessage->pData ),
         RTDS_PARAM_CODEC_MAX_DEPTH );
        
        RTDS_SIMULATOR_TRACE( RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext );
        RTDS_FREE( RTDS_globalPrintableParameters );
        RTDS_globalPrintableParameters = NULL;
        /* Release the message unique id back to the pool */
        RTDS_ReleaseMessageUniqueId( RTDS_currentContext->currentMessage->messageUniqueId );
    #endif
        
    #ifdef RTDS_ENV_FREE_PARAMETER
        if ( RTDS_currentContext->currentMessage->pData != NULL )
            {
            RTDS_FREE( RTDS_currentContext->currentMessage->pData );
            RTDS_currentContext->currentMessage->pData = NULL;
            }
    #endif
        
        /* Free memory */
        RTDS_FREE( RTDS_currentContext->currentMessage );
        RTDS_currentContext->currentMessage = NULL;
        } /* End of for ( ; ; ) */
    /* Resources clean up */
    RTDS_PROCESS_KILL;
    }
        
        
