#define RTDS_OK          0
#define RTDS_ERROR      -1

/*
 * DEFINE FOR QUEUE MANIPULATION:
 * ------------------------------
 */
#define RTDS_QUEUE_MAX_MSG                  20                              /* Maximum number of messages in a queue */
#define RTDS_QUEUE_MAX_MSG_LENGTH           sizeof( RTDS_MessageHeader )    /* Maximum length of messages in a queue */
#define RTDS_QUEUE_MAX_MSG_LENGTH_IN_BYTE   ( sizeof( RTDS_MessageHeader ) + sizeof( UNSIGNED ) -1 ) / sizeof( UNSIGNED ) /* Number of UNSIGNED elements for a message */

/*
 * DEFINE FOR SEMAPHORE MANIPULATION:
 * ------------------------------
 */
#define RTDS_SEMAPHORE_MAX_NAME_LENGTH  20                      /* Maximum length of a semaphore name */

#define RTDS_SEMAPHORE_TIME_OUT_FOREVER NU_SUSPEND              /* Time out option when taking the semaphore : wait forever */
#define RTDS_SEMAPHORE_TIME_OUT_NO_WAIT NU_NO_SUSPEND           /* Time out option when taking the semaphore : no wait */

#define RTDS_SEMAPHORE_OPTION_PRIO      NU_PRIORITY             /* Semaphore creation option: queuing based on priority */
#define RTDS_SEMAPHORE_OPTION_FIFO      NU_FIFO                 /* Semaphore creation option: queuing based on FIFO */

#define RTDS_BINARY_SEM_INITIAL_EMPTY   0                       /* Binary semaphore creation initial state: empty */
#define RTDS_BINARY_SEM_INITIAL_FULL    1                       /* Binary semaphore creation initial state: full */

#define RTDS_MUTEX_SEM_DELETE_SAFE
#define RTDS_MUTEX_SEM_INVERSION_SAFE

/*
 * DEFINE FOR PROCESS CREATION:
 * ----------------------------
 */
#define RTDS_TASK_OPTIONS_NUMBER        1                       /* Nucleus default number of task options */
#define RTDS_TASK_STACK_SIZE            1000                    /* Stack size when creating a new task */
#define RTDS_DEFAULT_PROCESS_PRIORITY   125                     /* If priority not defined in SDL-RT, it will be given this value */
#define SYSTEM_MEMORY_SIZE              50000                   /* Size of system memory pool */
#define RTDS_PROCESS_FINISHED           1                       /* processKill (in RTDS_GlobalProcessInfo) field has this value if the process wants to die */
#define RTDS_PROCESS_NOT_FINISHED       0                       /* processKill (in RTDS_GlobalProcessInfo) field has this value if the process is running */

/* ************************************************************************************ *
CRITICAL SECTION MACROS
 * ************************************************************************************ */
#define RTDS_CRITICAL_SECTION_DECL      RTDS_SemaphoreId RTDS_globalSystemSemId;
#define RTDS_CRITICAL_SECTION_PROTO     extern RTDS_SemaphoreId RTDS_globalSystemSemId;
#define RTDS_CRITICAL_SECTION_INIT \
    RTDS_globalSystemSemId = ( RTDS_SemaphoreId )RTDS_MALLOC( sizeof( NU_SEMAPHORE ) ); \
    if ( NU_Create_Semaphore( RTDS_globalSystemSemId, "C_SC_I", 1, NU_FIFO ) != NU_SUCCESS ) \
        { \
        RTDS_SYSTEM_ERROR( RTDS_ERROR_CREATE_CRITICAL_SECTION ); \
        }

#define RTDS_CRITICAL_SECTION_START \
    if ( NU_Obtain_Semaphore( RTDS_globalSystemSemId, RTDS_SEMAPHORE_TIME_OUT_FOREVER ) != NU_SUCCESS ) \
        { \
        RTDS_SYSTEM_ERROR( RTDS_ERROR_CREATE_CRITICAL_SECTION_START ); \
        }

#define RTDS_CRITICAL_SECTION_STOP \
    if ( NU_Release_Semaphore( RTDS_globalSystemSemId ) != NU_SUCCESS ) \
        { \
        RTDS_SYSTEM_ERROR( RTDS_ERROR_CREATE_CRITICAL_SECTION_STOP ); \
        }

#define RTDS_CRITICAL_SECTION_POSTAMBLE \
    if ( NU_Delete_Semaphore( RTDS_globalSystemSemId ) != NU_SUCCESS ) \
        { \
        RTDS_SYSTEM_ERROR( RTDS_ERROR_CREATE_CRITICAL_SECTION_DELETE ); \
        }

/* ************************************************************************************ *
 *STARTUP SYNCHRONISATION
 * ************************************************************************************ */
#define RTDS_HOLD                       1
#define RTDS_NO_HOLD                    0

/* ************************************************************************************ *
 *COVERAGE INFORMATION
 * ************************************************************************************ *
 * The coverage information is stored in an array of unsigned char. The SDL-RT symbol
 * number is used as an index; the value stored is the number of times the symbol has
 * been executed. It can not exceed 0xFF for each symbol.
 * ************************************************************************************ */
#ifdef RTDS_COVERAGE_NB_SYMBOLS
    #define RTDS_COVERAGE_DECL              unsigned char RTDS_globalCoverage[ RTDS_COVERAGE_NB_SYMBOLS ];
    #define RTDS_COVERAGE_PROTO             extern RTDS_COVERAGE_DECL
    #define RTDS_COVERAGE_INIT \
        { \
        int RTDS_i; \
        for ( RTDS_i = 0; RTDS_i < RTDS_COVERAGE_NB_SYMBOLS; RTDS_i++ ) \
            { \
            RTDS_globalCoverage[ RTDS_i ] = 0; \
            } \
        }
    #define RTDS_COVERAGE_LOG( SYMBOL_NUMBER ) \
        if ( RTDS_globalCoverage[ SYMBOL_NUMBER ] != 0xFF ) \
            { \
            RTDS_globalCoverage[ SYMBOL_NUMBER ]++; \
            }
#else
        #define RTDS_COVERAGE_DECL
        #define RTDS_COVERAGE_PROTO
        #define RTDS_COVERAGE_INIT
#endif


/*
 * DEFINE FOR SIMULATION:
 * ----------------------
 */
#ifdef RTDS_SIMULATOR
    /* Define on how many bytes the messageUniqueId pool will be made of */
    /* 1 means 1 byte means 1*8 bits means 8 possible simultaneous values */
    /* Maximum is 8192 since the id a long type */
    #define RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE        64
    /* Number of levels when formatting message parameters to be printable */
    /* in the SDL-RT debugger */
    #define RTDS_PARAM_CODEC_MAX_DEPTH              4
    /* Min size of memory chunk used when formatting message parameters */
    /* to be printable in the SDL-RT debugger */
    #define RTDS_PARAM_CODEC_CHUNK_SIZE             128
#endif

/*
 * TYPE RTDS_QUEUE.ID:
 * ----------------------
 * Type for a message queue identifier
 */
typedef NU_QUEUE * RTDS_RtosQueueId;

/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 */
typedef NU_SEMAPHORE * RTDS_SemaphoreId;

/*
 * TYPE RTDS_PROCESS_ID:
 * ----------------------
 * Type for a pid
 */
typedef NU_TASK * RTDS_RtosTaskId;

/*
 * TYPE RTDS_TIMER_ID:
 * ----------------------
 * Type for a timer identifier
 */
typedef NU_TIMER * RTDS_TimerId;

/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef STATUS RTDS_SemaphoreStatus;

/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef int RTDS_SemaphoreTimeout;

/*
 * TYPE RTDS_PROCESS_PRIORITY:
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;

/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */
#define RTDS_TIMER_OK           1
#define RTDS_TIMER_CANCELLED    0

typedef struct RTDS_TimerState
    {
    long timerNumber;                           /* Message number for the timer name */
    long timerUniqueId;                         /* Timer's unique identifier among all timers */
    unsigned long timeoutValue;                 /* System tick counter value when it will go off */
    struct RTDS_SdlInstanceId * receiverId;     /* The instance id of the receiver */
    int state;                                  /* State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
    RTDS_TimerId watchDogId;                    /* Id of the Nucleus watchDog */
    struct RTDS_MessageHeader * watchDogParam;  /* Parameter wich may be sent by the WatchDogFunction */
    struct RTDS_TimerState * next;              /* Next timer in list */
    } RTDS_TimerState;

/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 */
typedef struct RTDS_GlobalSemaphoreInfo
    {
    RTDS_SemaphoreId semaphoreId;           /* The semaphore address */
    int semaphoreNumber;                    /* Semaphore number representing its name */
    struct RTDS_GlobalSemaphoreInfo * next; /* Next semaphoreInfo */
    } RTDS_GlobalSemaphoreInfo;

RTDS_COVERAGE_PROTO
RTDS_CRITICAL_SECTION_PROTO

/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS

/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
  RTDS_ProcessPriority priority; VOID * queueArea; VOID * processStack; int processKill;

