#ifndef _RTDS_SEMAPHORE_PROCESS_H_
#define _RTDS_SEMAPHORE_PROCESS_H_

#include "RTDS_Proc.h"

/*
** TYPE RTDS_WaitingProcessList:
** -----------------------------
** Chained list for instances waiting for a semaphore
*/

struct RTDS_WaitingInstanceList
{
  RTDS_SdlInstanceId            instanceId;
  RTDS_WaitingInstanceList    * next;
};


/*
** PROCESS RTDS_SemaphoreProcess:
** ------------------------------
*/

class RTDS_SemaphoreProcess : public RTDS_Proc
{
  public:
    // Constructor
    RTDS_SemaphoreProcess(RTDS_Scheduler *parentScheduler);
    
    // Destructor
    virtual ~RTDS_SemaphoreProcess();
        
    // Checks if the semaphore is available
    virtual short isAvailable() = 0;
    
  protected:
    RTDS_WaitingInstanceList  * firstWaitingInstance;
    RTDS_WaitingInstanceList  * lastWaitingInstance;
    
    // Add an instance to list of waiting instances
    void pushWaitingInstance(RTDS_SdlInstanceId &instanceId);
    
    // Pops the first waiting instance from the list
    RTDS_SdlInstanceId &popWaitingInstance();
    
    // Removes a given waiting instance from the list
    short removeWaitingInstance(RTDS_SdlInstanceId &instanceId);
};

#endif
