#ifndef _RTDS_PROXY_H_
#define _RTDS_PROXY_H_

#define RTDS_SETSIZE 1024

#include "RTDS_Proc.h"

#include "ns3/core-module.h"
#include "ns3/simulator-module.h"
#include "ns3/node-module.h"
#include "ns3/helper-module.h"

struct RTDS_TimerState;

class RTDS_Proxy: public RTDS_Proc
{
  public:
    RTDS_Proxy(RTDS_Scheduler *parentScheduler);
    ~RTDS_Proxy();
    short RTDS_continuousSignals(int *lowestPriority);
    short RTDS_executeTransition(RTDS_MessageHeader *currentMessage);

    ns3::Ptr<ns3::Socket> listeningSocket;
    ns3::Ptr<ns3::Socket> slots[RTDS_SETSIZE];
    
    ns3::Ptr<ns3::Socket> RTDS_create(char *address, unsigned short port, short listening, short *connected);
    void RTDS_accept(ns3::Ptr<ns3::Socket> sock, const ns3::Address &addr);
    void RTDS_connectOk(ns3::Ptr<ns3::Socket> sock);
    void RTDS_connectKo(ns3::Ptr<ns3::Socket> sock);
    void RTDS_send(ns3::Ptr<ns3::Socket> sock, uint32_t bytes);
    void RTDS_receive(ns3::Ptr<ns3::Socket> sock);
    
    RTDS_MessageHeader *RTDS_pending(ns3::Ptr<ns3::Socket> sock);
    
    int RTDS_insert(ns3::Ptr<ns3::Socket> sock);
    void RTDS_remove(ns3::Ptr<ns3::Socket> sock);
};

#endif

