#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include "ns3/simulator.h"

#include "RTDS_SemaphoreProcess.h"
#include "RTDS_SemaphoreTakeProcedure.h"
#include "RTDS_Error.h"

#define RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE 2048 // 2048 * 32 = 65536 of unique ids

class RTDS_Proc;

extern FILE *RTDS_traceFile;
extern uint32_t RTDS_globalMessageUniqueIdPool[RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE];

extern int RTDS_TraceOpen(const char *fileName);
extern int RTDS_TraceClose();

extern int RTDS_GetMessageUniqueId(void);
extern void RTDS_ReleaseMessageUniqueId(int messageUniqueId);

extern long long RTDS_TickGet();
extern void RTDS_TimerStop(RTDS_Proc *owner, int timerNumber);
extern void RTDS_TimerStart(RTDS_Proc *owner, int timerNumber, int delay);

extern short RTDS_IsDefaultComponent(char *nodeId, char *componentId);
extern short RTDS_SocketStart();
extern short RTDS_SocketStop();

#endif
