#ifndef _RTDS_MUTEX_SEMAPHORE_PROCESS_H_
#define _RTDS_MUTEX_SEMAPHORE_PROCESS_H_

#include "RTDS_SemaphoreProcess.h"


/*
** PROCESS RTDS_MutexSemaphoreProcess:
** --------------------------------------
*/

class RTDS_MutexSemaphoreProcess: public RTDS_SemaphoreProcess
{
  public:
    RTDS_SdlInstanceId takerInstanceId;
    unsigned int takeCount;
    
    // Constructor
    RTDS_MutexSemaphoreProcess(RTDS_Scheduler *parentScheduler);
    
    // Checks if the semaphore is available
    virtual short isAvailable();
    
    // Entry point for transitions for continuous signals
    short RTDS_continuousSignals(int *lowestPriority);

    // Entry point for all transitions
    short RTDS_executeTransition(RTDS_MessageHeader *currentMessage);
};

#endif
