/* **************************************************************** */
/* $(RTDS_HOME)/share/ccg/FreeRTOS/bricks/RTDS_Startup_end.c begins */
/* PragmaDev RTDS FreeRTOS integration                              */

/* Let all the created process run now */
RTDS_START_SYNCHRO_GO;

RTDS_SIMULATOR_TRACE(RTDS_initDone, NULL, NULL, NULL);
	
vTaskDelete( NULL );
}


/* **************************************************************** *
 *    main
 * **************************************************************** *
 *    Main entry
 * **************************************************************** */
#ifndef RTDS_MAIN
int main( void )
#else
int RTDS_MAIN( void )
#endif
{
	int RTDS_i;
		
	RTDS_COVERAGE_INIT;

	#ifdef RTDS_SIMULATOR
		/* Set up the message unique id pool */
		RTDS_globalMessageUniqueIdPool = (unsigned char *)RTDS_MALLOC(RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE);
			{
			unsigned char *RTDS_index;

			RTDS_index = RTDS_globalMessageUniqueIdPool;
			for(RTDS_i=0;RTDS_i<RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE;RTDS_i++)
				{
				*RTDS_index=0x00;
				RTDS_index++;
				}
			}
	#endif

	#if defined(RTDS_SIMULATOR) && defined(RTDS_BACK_TRACE_MAX_EVENT_NUM)
		/* Initialize circular buffer to trace in RAM */
		RTDS_TraceInit();
	#endif

	RTDS_SOCKET_ACCESS_INIT;
	RTDS_CRITICAL_SECTION_INIT;
	RTDS_START_SYNCHRO_INIT;
	RTDS_CRITICAL_TRACE_SECTION_INIT;

	/* Init acknowledge semaphore */
	RTDS_DTRACE_ACKNOWLEDGE_INIT;

#if RTDS_SOCKET_PORT
 
	clientSocketId = RTDS_InitSocket( GET_HOSTNAME_STRING( RTDS_SOCKET_IP_ADDRESS ), RTDS_SOCKET_PORT );
	if( !(clientSocketId == RTDS_ERROR || clientSocketId == 0 ) )
		{
		socketEnable = 1;
		/* global variable for sending data */
		globalClientSocketId = clientSocketId;
		}
#endif

/* Call Start function (that will run SDL Task and run program) */
/* RTDS_Start is started in a thread because to prevent startup deadlock with RTDS_Socket() */
/* Task creation */
if ( xTaskCreate( 
	(pdTASK_CODE) RTDS_Start, 
	"RTDS_Start", 
	(unsigned portSHORT) RTDS_TASK_STACK_SIZE, 
	(void *) NULL, 
	(unsigned portBASE_TYPE) RTDS_DEFAULT_PROCESS_PRIORITY, 
	(xTaskHandle *)NULL 
	) != pdPASS  )
		{
		RTDS_SYSTEM_ERROR(RTDS_ERROR_PROCESS_CREATE_TASK_SPAWN);
		}

vTaskStartScheduler(); 		/* Enter RTOS. Will never return unless the whole system stops. */

/* Should never get here. */
return 0;
}

/* $(RTDS_HOME)/share/ccg/FreeRTOS/bricks/RTDS_Startup_end.c ends */
/* ************************************************************** */

