/* PragmaDev RTDS FreeRTOS integration */

/* To deal with recursive includes */
#ifndef INCLUDE_RTDS_OS_H
#define INCLUDE_RTDS_OS_H

#include "stdlib.h"

/* RTDS include */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes, semaphores and timers
 */
extern RTDS_GlobalProcessInfo 	*RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo *RTDS_globalSemaphoreInfo;

#ifdef RTDS_SIMULATOR
extern unsigned char				*RTDS_globalMessageUniqueIdPool;
extern RTDS_GlobalTraceInfo 		RTDS_globalTraceEntry;
#endif



/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */

extern long                 RTDS_GetTimerUniqueId       ( RTDS_TimerState * );
extern void                 RTDS_WatchDogFunction       ( xTimerHandle pxTimer );
extern void                 RTDS_StartTimer             ( RTDS_SdlInstanceId *, long , long , int , RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void                 RTDS_StopTimer              ( long , RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void                 RTDS_MsgQueueSend           ( long , long, unsigned char *, RTDS_SdlInstanceId *, RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * );
extern int                  RTDS_MsgQueueReceive        ( RTDS_SdlInstanceId *, unsigned char * , int );
extern RTDS_SdlInstanceId	* RTDS_GetProcessQueueId    ( int );
extern void                 RTDS_ProcessCreate          ( char * processName, int processNumber, void (*)(RTDS_GlobalProcessInfo*) , int , RTDS_SdlInstanceId ** ,RTDS_SdlInstanceId *, short, RTDS_GlobalProcessInfo * );
extern void                 RTDS_ProcessKill            ( RTDS_GlobalProcessInfo * );
extern void                 RTDS_Sem_Delete             ( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake        ( RTDS_SemaphoreId , RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId     RTDS_GetSemaphoreId         ( int semaphoreNumber );
extern void                 RTDS_Sem_Info_Insert        ( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId     RTDS_BinarySemaphoreCreate	( int semaphoreNumber, unsigned char initialState, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId     RTDS_MutexSemaphoreCreate 	( int semaphoreNumber, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId     RTDS_CountingSemaphoreCreate( int semaphoreNumber, unsigned char initialCount, RTDS_GlobalProcessInfo * );
extern void                 RTDS_TransitionCleanUp      ( RTDS_GlobalProcessInfo *RTDS_currentContext, int RTDS_sdlStatePrev );
extern portTickType         RTDS_GetSystemTime          ( void );

#ifdef RTDS_SIMULATOR
    extern unsigned long        RTDS_GetMessageUniqueId     ( void );
    extern void                 RTDS_ReleaseMessageUniqueId ( unsigned long );
    extern void                 RTDS_DummyTraceFunction     ( void );
    extern void                 RTDS_messageDataToString    ( char ** buffer, long messageNumber, long dataLength, void* dataPointer, int level);
    extern char                 *RTDS_stringToMessageData 	( long messageNumber, long * dataLength, void ** dataPointer, char * dataString);
    #if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER )
        extern void RTDS_SimulatorTrace( enum RTDS_EventType event, void * eventParameter1, long eventParameter2, RTDS_GlobalProcessInfo * currentContext, int waitAck);
    #endif
#endif

#if defined( RTDS_SIMULATOR ) && defined( RTDS_SOCKET_PORT )
    /* For using the command interpreter */
    extern void RTDS_ForceTimer( RTDS_SdlInstanceId * sdlInstanceId, int timerNumber );
    #ifdef TO_DO
    extern void RTDS_SetSystemTime( long timeValue );
    #endif
    extern void RTDS_SimulatorMsgQueueSend( long , long, unsigned char *, RTDS_SdlInstanceId * , RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo *RTDS_currentContext );
#endif /* RTDS_SIMULATOR and RTDS_SOCKET_PORT */

#if defined( RTDS_FORMAT_TRACE ) || defined( RTDS_SIMULATOR )
    /* For using the dynamic trace: RTDS_SYSTEM_ERROR */
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromSdlInstanceId( RTDS_SdlInstanceId * sdlInstanceId );
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromProcessNum( int sdlProcessNumber );
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromRtosTaskId( RTDS_RtosTaskId rtosTaskId );
    extern RTDS_RtosTaskId          RTDS_GetCurrentRtosTaskId( void );
    extern long                     RTDS_IsSemaphoreAvailable( RTDS_SemaphoreId semaphoreId );
#endif /* RTDS_SIMULATOR */


#endif /* INCLUDE_RTDS_OS_H */

