#include "RTDS_InstanceManager.h"


/* Initialization of the class attribute for the list of instances */
RTDS_InstanceManagerList * RTDS_InstanceManager::instanceList = NULL;


/*
** CONSTRUCTOR:
** ------------
** Associates a process number to the function creating instances of this process
** - processNumber: Identifier for the process "name"
** - creationFunction: Function creating an instance of this process
*/

RTDS_InstanceManager::RTDS_InstanceManager(int processNumber, InstanceCreationFunction creationFunction)
{
  RTDS_InstanceManagerList  * listElement = NULL;
  
  /* Store the creation function */
  this->creationFunction = creationFunction;
  /* Records this instance in class's instance list */
  listElement = new RTDS_InstanceManagerList;
  listElement->processNumber = processNumber;
  listElement->manager = this;
  listElement->next = instanceList;
  instanceList = listElement;
}


/*
** CLASS OPERATION createInstance:
** -------------------------------
** Actually creates an instance of a given process
** - processNumber: Identifier for the process "name" for the instance to create
** Returns: The object for the created instance
*/
RTDS_Proc *
RTDS_InstanceManager::createInstance(RTDS_Scheduler * parentScheduler, int processNumber)
{
  RTDS_InstanceManagerList  * listElement = NULL;
  
  /* Look for instance corresponding to the given process number in instance list */
  for ( listElement = instanceList; listElement != NULL; listElement = listElement->next )
  {
    /* If manager instance is the one, create instance by calling its creation function */
    if ( listElement->processNumber == processNumber )
      return listElement->manager->creationFunction(parentScheduler);
  }
  /* (Shouldn't happen) */
  return NULL;
}
