/* Copyright 2013 Humboldt University of Berlin
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* Author: Mihal Brumbulli <mbrumbulli@gmail.com>
*/

#ifndef _TRACER_H_
#define _TRACER_H_

#include <string>
#include <vector>
#include <pthread.h>

class Tracer 
{
  public:
    enum {IDLE, OPENED, CONNECTED, CLOSED};	        // Tracer status options
    
    static std::vector<Tracer>      tracerList;     // Tracer list
    static std::vector<pthread_t>   threadList;     // Thread list
	
    static pthread_t                pollThread;     // Thread for continously checking tracers
    static std::string              tracerCommand;  // Tracer command
    
    static bool                     doPoll_;        // Toggle tracer checking (i.e., terminate checking thread)
    static pthread_mutex_t          pollLock_;      // Guard access to doPoll
    static unsigned int             pollInterval;   // Tracer check interval (ms)
  
  private:
    unsigned short                  port_;          // Tracer port
    int                             sock_;          // Tracer socket
    int                             status_;        // Tracer status
    pthread_mutex_t                 lock_;          // Guard access to member attributes
    
  public:
    // Constructor
    Tracer();
    // Destructor
    ~Tracer();
    // Atomic getters and setters
    unsigned short port();
    void port(unsigned short value);
    int sock();
    void sock(int value);
    int status();
    void status(int value);

    static bool doPoll();
    static void doPoll(bool value);
    
    static void Open();
    static void Close();
    static void Launch(unsigned long id);
    static void * Create(void *arg);
    static void * Poll(void *arg);
    static bool Send(const char* buffer);
};

#endif
