/* **************************************************************** *
 * Copyright PragmaDev 2003
 * **************************************************************** *
 * This an example client program to send information to the
 * PragmaDev MSC tracer. It automatically creates several traces
 * from the client itself and makes the tracer exit in the end.
 *
 * It should be used without MSC tracer's GUI
 * **************************************************************** */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "TracerSocketConnection.h"


#define T_SIZE 16
#define NB_TRACES 4

int main(int argc, char ** argv)
  {
  /* List of tarcer commands */
  char *tabMsg[T_SIZE] =
    {
    "taskCreated| -t90| -npPing| 0x01|\n",
    "taskCreated| -t100| -npPong| 0x02|\n",
    "messageSent| -t110| 0x01| 1| mPing|\n",
    "messageReceived| -t120| 0x02| 1| mPing|\n",
    "messageSent| -t130| 0x02| 2| mPong|\n",
    "messageReceived| -t140| 0x01| 2| mPong|\n",
    "messageSent| -t150| 0x01| 1| mPing|\n",
    "messageReceived| -t160| 0x02| 1| mPing|\n",
    "messageSent| -t170| 0x02| 2| mPong|\n",
    "messageReceived| -t180| 0x01| 2| mPong|\n",
    "messageSent| -t190| 0x01| 1| mPing|\n",
    "messageReceived| -t200| 0x02| 1| mPing|\n",
    "messageSent| -t210| 0x02| 2| mPong|\n",
    "messageReceived| -t220| 0x01| 2| mPong|\n",
    "taskDeleted| -t230| 0x02|\n",
    "taskDeleted| -t240| 0x01|\n"
    };

  /* IP address and port number for server */
  char ipAddress[16];
  unsigned short portNumber;
  /* Command to start a trace */
  char startCmd[256];

  int i, j, cr;

  /* Decode command line arguments */
  if ( argc < 2 || argc > 3 )
    {
    printf("Usage: %s [<ip address>] <port number>\n", argv[0]);
    exit(0);
    }
  else if (argc<3)
    {
    strcpy(ipAddress, "127.0.0.1");
    portNumber = atoi(argv[1]);
    }
  else
    {
    strcpy(ipAddress, argv[1]);
    portNumber = atoi(argv[2]);
    }
  
  /* Connect to tracer */
  if ( startTracing(ipAddress, portNumber) < 0 )
    {
    fprintf(stderr, "Connection error! Exiting...\n");
    exit(0);
    }
  printf("Connection OK.\n");
  
  /* For all traces that should be done */
  for ( i = 0; i < NB_TRACES; i++ )
    {
    /* Build and send command starting trace */
    sprintf(startCmd, "newTrace| -fTrace%d.rdd|\n", i + 1);
    sendToTracer(startCmd);
    /* Send all trace commands to tracer */
    for( j = 0; j < T_SIZE; j++ )
      {
      /* Send command to tracer */
      sendToTracer(tabMsg[j]);
      }
    /* Make sure tracer has received all commands */
    waitForAck();
    /* Close current trace */
    sendToTracer("close|\n");
    }
  /* Ask tracer to exit */
  sendToTracer("exit|\n");
  /* Close socket */
  printf("Closing socket: %d\n", endTracing());
  }

