#ifndef SUT_H_
#define SUT_H_

/* charstring in TTCN are generated as char array of size 256. */
typedef char StringtoReceive[256];

typedef struct _AnswerMessageType_1
  {
  int i;
  } AnswerMessageType_1;
  
typedef struct _AnswerMessageType_2
  {
  StringtoReceive s;
  int i;
  } AnswerMessageType_2;

/* Classe descripton for SUT */

class SUT_class
{
public:
SUT_class(){}

//method handleRequestMessage_1 to receive message type mRequest_1 from TTCN
void handleRequestMessage_1(int);

//method handleRequestMessage_2 to receive message type mRequest_2 from TTCN
void handleRequestMessage_2(int, int);

//method handleRequestMessage_3 to receive message type mRequest_3 from TTCN
void handleRequestMessage_3(int, StringtoReceive);
  
//method handleRequestMessage_4 to receive message type mRequest_4 from TTCN
void handleRequestMessage_4(StringtoReceive, StringtoReceive);

};


/* ****************************************************************************************** *
 * sendAnswerMessageType1ToEnv and sendAnswerMessageType2ToEnv are called by the SUT
 * to send messages of type AnswerMessageType_1 or AnswerMessageType_2 to the TSI.
 * ****************************************************************************************** */
void sendAnswerMessageType1ToEnv(AnswerMessageType_1 * message);
void sendAnswerMessageType2ToEnv(AnswerMessageType_2 * message);

#endif 
