#ifndef _RTDS_SUT_INTERFACE_H_
#define _RTDS_SUT_INTERFACE_H_

#include "SUT.h"

int SUT_init(void);

/* **************************************************************** *
 *         RTDS_TTCN_SEND_MESSAGE_VIA_TSI_PORT_sut_port
 * **************************************************************** *
 * The TTCN test calls this macro to send a message to the SUT.
 * 
 * In our example, this macro will do a synchronous call to the 
 * function handleRequestMessage defined in SUT.c.
 * **************************************************************** *
 * Parameters:
 *     MESSAGE_HEADER : RTDS_MessageHeader *  message sent by the TTCN test.
 * Returns:
 *     Nothing
 * **************************************************************** */

#define RTDS_TTCN_SEND_MESSAGE_VIA_TSI_PORT_sut_port(MESSAGE_HEADER) \
  handleRequestMessage((RequestMessageType*)(MESSAGE_HEADER->pData))

/* **************************************************************** *
 * When sending a message from the TTCN test, a RTDS_MessageHeader* 
 * variable is passed as parameter.
 *
 * The parameter pData of this struct is a pointer to the message data.
 *
 * TTCN type mRequest used to send message is generated as a struct of
 * one parameter. A pointer of this type is passed as pData when sending 
 * the message. To read received message, a cast with RequestMessageType
 * type is done. 
 * **************************************************************** */

#endif 
