#include <stdio.h>

#include "RTDS_TTCN_SUT_interface.h"
#include "SUT.h"

#include "RTDS_TTCN_MACRO.h"
#include "RTDS_TTCN.h"
#include "RTDS_TTCN_gen.h"


/* Static output queue for message going out of the system */
static RTDS_TTCN_SystemInterfacePort SUT_output_queue;

/* ******************************************************************************* *
 * In generated code for TTCN, a global variable RTDS_TTCN_systemInterfacePorts
 * is declared to store every ports of system interface. This variable will 
 * be used in the system under test to store ports.
 * ******************************************************************************* */
RTDS_TTCN_SystemInterfacePort * RTDS_TTCN_systemInterfacePorts = NULL;

/* **************************************************************** *
 *    SUT_init
 * **************************************************************** *
 * Called in TTCN to init received port for SUT
 * **************************************************************** *
 * Parameters:
 *     Nothing
 * Returns:
 *     Nothing
 * **************************************************************** */
int SUT_init(void)
  {
  /* Define and add sut_port to the ports list of the TSI */
  SUT_output_queue.portName = "sut_port";
  SUT_output_queue.portMessageQueue = RTDS_NEW_MESSAGE_QUEUE;
  SUT_output_queue.next = NULL;
  RTDS_TTCN_systemInterfacePorts = &SUT_output_queue;
  }


/* **************************************************************** *
 *    sendAnswerMessageToEnv
 * **************************************************************** *
 * Used by the SUT to send a message to the environment
 * **************************************************************** *
 * Parameters:
 *    - message : AnswerMessageType *   Message to send
 * Returns:
 *    Nothing
 * **************************************************************** *
 * Parameters of RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID_FROM_SUT:
 *    -RTDS_TTCN_Sig_mAnswer : Number of the message, defined by TTCN.
 *    -sizeof : AnswerMessageType and TTCN record type mAnswer are
 * defined the same way to allow communication.
 *    -message : Build on type AnswerMessageType, the same type than
 * the one generated for TTCN record type mAnswer.
 *    -receiver : Receiver instance is set to NULL because is not know
 * by the system under test.
 *    -SUT_output_queue.portMessageQueue : port of the TSI.
 * **************************************************************** */
void sendAnswerMessageToEnv(AnswerMessageType * message)
  {
  RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID_FROM_SUT(RTDS_message_mAnswer, sizeof(AnswerMessageType), message, NULL, SUT_output_queue.portMessageQueue);
  }
  
