#include <stdlib.h>
#include <stdio.h>

#include "RTDS_Common.h"
#include "RTDS_Proc.h"

/*
** Two process instances will be created: one pSender and one pReceiver
** Both instances need a context (type RTDS_GlobalProcessInfo) and a
** descriptor (type RTDS_Proc).
*/
RTDS_GlobalProcessInfo process_contexts[2];
RTDS_Proc process_descriptors[2];

/*
** The external scheduler usually does not use message identifiers coming
** from RTDS. Here is the type for the scheduler's own message identifiers.
** NB: sOver is not there, because it actually goes to the environment and
** will be not be handled as a signal in a queue.
*/
typedef enum _MessageIdentifier
	{
	ack_message,
	ping_message
	} MessageIdentifier;

/*
** The external scheduler has to provide its own way of sending messages, which
** will be called by processes generated by RTDS via macros. This case is quite
** simple: messages have no parameter and only one process instance can receive
** a given message.
** So we can create a function sending a given message to a given instance, identified
** by its index in the arrays process_contexts & process_descriptors above:
*/
void message_send(MessageIdentifier message_id, int receiver_index);

/*
** Then the macros used by RTDS to send the signal will have the receiver 'hardcoded'
** in the function call:
*/
#define RTDS_MSG_SEND_sPing message_send(ping_message, 1)

#define RTDS_MSG_SEND_sAck message_send(ack_message, 0)

/* Special case for sOver: just print a message */
#define RTDS_MSG_SEND_sOver printf("Over!\n")

/*
** NB: the macros have no parameter because the signals don't have any either. For a signal
** with parameters, the macro would receive the signal parameters as arguments.
**
** If the context for the sender instance is needed, a variable named RTDS_currentContext
** with type RTDS_GlobalProcessInfo is always present in the context of the caller of the
** RTDS_MSG_SEND_* macros. See $RTDS_HOME/share/ccg/common/RTDS_Common.h for the available
** fields in RTDS_GlobalProcessInfo.
*/

