#include "portable_sockets.h"

#include "constants.h"

#include "RTDS_MACRO.h"
#include "RTDS_gen.h"
#include "RTDS_messages.h"
#include "client_communication.h"

SOCKET_GLOBALS

/*
** VARIABLE socket_descriptor:
** ---------------------------
** Identifier for the socket connected to the client.
*/
static SOCKET socket_descriptor = INVALID_SOCKET;


/*
** FUNCTION init_socket:
** ---------------------
** Makes sure the socket is connected to the client.
** Returns: The identifier for the connected socket.
*/

int init_socket(void)
  {
  struct sockaddr_in  s_in;             /* Pointer on server address descriptor */
  struct sockaddr_in  client_s_in;      /* Pointer on client address descriptor */
  socklen_t           client_s_in_len;  /* Length for client address descriptor */
  
  /* If socket is not connected yet */
  if ( socket_descriptor == INVALID_SOCKET )
    {
    SOCKET_STARTUP
    
    /* Create socket */
    socket_descriptor = socket(AF_INET, SOCK_STREAM, 0);
    if ( socket_descriptor == INVALID_SOCKET )
      {
      fprintf(stderr, "init_socket - socket: error %d\n", ERRNO);
      abort();
      }
    /* Bind socket to current host of the correct port */
    s_in.sin_family = AF_INET;
    s_in.sin_addr.s_addr = htonl(INADDR_ANY);
    s_in.sin_port = htons(atoi(PORT_NUMBER_STRING));
    if ( bind(socket_descriptor, (struct sockaddr*)(&s_in), sizeof(s_in)) == SOCKET_ERROR )
      {
      fprintf(stderr, "init_socket - bind: error %d\n", ERRNO);
      abort();
      }
    else
      {
      /* Listen for external connections */
      if ( listen(socket_descriptor, 1) == SOCKET_ERROR )
        {
        fprintf(stderr, "init_socket - listen: error %d\n", ERRNO);
        abort();
        }
      /* Wait for client connection */
      client_s_in_len = sizeof(struct sockaddr_in);
      socket_descriptor = accept(socket_descriptor, &client_s_in, &client_s_in_len);
      if ( socket_descriptor == INVALID_SOCKET )
        {
        fprintf(stderr, "init_socket - accept: error %d\n", ERRNO);
        abort();
        }
      }
    }
  /* If no connection received, error */
  if ( socket_descriptor == INVALID_SOCKET )
    {
    fprintf(stderr, "no suitable addrinfo found!\n");
    abort();
    }
  /* Return identifier for socket connected to the client */
  return socket_descriptor;
  }
  

/*
** FUNCTION send_to_client:
** ------------------------
** Sends a message to the client through the socket.
** Parameters:
**  - message_number: Numerical identifier for the sent message, as defined in RTDS_gen.h
**  - data_length: Length for the buffer containg the message parameters
**  - data_pointer: Pointer on the buffer containg the message parameters
*/

void send_to_client(int message_number, unsigned data_length, void * data_pointer)
  {
  RTDS_m_result_data  * params;               /* Parameters for m_result message */
  char                  encoded_message[64];  /* Encoded message, sent to the client through the socket */
  
  /* Make sure socket is connected tothe client */
  init_socket();
  /* Figure out message to send */
  switch(message_number)
    {
    /* Encode message and parameters for m_result */
    case RTDS_message_m_result:
      params = (RTDS_m_result_data*)data_pointer;
      sprintf(encoded_message, "r%d", params->param1);
      break;
    /* No other recognized messages */
    default:
      return;
    }
    
  /* Actually send encoded message to the distant client through the socket */
  send(socket_descriptor, encoded_message, 1 + strlen(encoded_message), 0);
  }
