/*
 * Decompiled with CFR 0.152.
 */
package plug.statespace.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.statespace.ITransitionStorage;

public class FullTransitionStorage<C extends IConfiguration, A>
implements ITransitionStorage<C, A> {
    Map<C, List<IFiredTransition<C, A>>> adjacencyList = new HashMap<C, List<IFiredTransition<C, A>>>();
    int size = 0;
    int edgeCount = 0;

    @Override
    public synchronized IFiredTransition put(IFiredTransition<C, A> transition) {
        Optional<IFiredTransition> alreadyPresent;
        ++this.size;
        this.edgeCount += transition.getTargets().size();
        List<IFiredTransition<C, A>> fanout = this.adjacencyList.get(transition.getSource());
        if (fanout == null) {
            fanout = new ArrayList<IFiredTransition<C, A>>();
            this.adjacencyList.put(transition.getSource(), fanout);
        }
        if (!(alreadyPresent = fanout.stream().filter(t -> Objects.equals(t.getAction(), transition.getAction()) && transition.getTargets().containsAll(t.getTargets())).findAny()).isPresent()) {
            fanout.add(transition);
            return transition;
        }
        return alreadyPresent.get();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public C getParent(C configuration) {
        for (Map.Entry<C, List<IFiredTransition<C, A>>> entry : this.adjacencyList.entrySet()) {
            for (IFiredTransition<C, A> transition : entry.getValue()) {
                for (IConfiguration target : transition.getTargets()) {
                    if (target != configuration) continue;
                    return (C)((IConfiguration)transition.getSource());
                }
            }
        }
        return null;
    }

    @Override
    public synchronized Collection<IFiredTransition<C, A>> getFiredFrom(C configuration) {
        Collection result = this.adjacencyList.get(configuration);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public synchronized Collection<IFiredTransition<C, A>> getFiredTo(C configuration) {
        ArrayList<IFiredTransition<C, A>> result = new ArrayList<IFiredTransition<C, A>>();
        for (Map.Entry<C, List<IFiredTransition<C, A>>> entry : this.adjacencyList.entrySet()) {
            block1: for (IFiredTransition<C, A> transition : entry.getValue()) {
                for (IConfiguration target : transition.getTargets()) {
                    if (!target.equals(configuration)) continue;
                    result.add(transition);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }
}

