/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer;

import java.util.LinkedList;
import java.util.Queue;
import plug.core.IConfiguration;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.explorer.AbstractExplorer;
import plug.explorer.buchi.nested_dfs.Color;

public class BoundedBFSExplorer<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    protected final int targetDepth;
    protected int currentDepth;
    protected final Queue<C>[] toSee = new Queue[2];
    protected int currentQueueID = 0;

    public BoundedBFSExplorer(ITransitionRelation<C, ?> runtime, IStateSpaceManager<C, A> stateSpaceManager, int targetDepth) {
        super(runtime, stateSpaceManager);
        this.targetDepth = targetDepth;
    }

    @Override
    public void initializeExploration() {
        this.currentDepth = 0;
        this.toSee[0] = new LinkedList<C>();
        this.toSee[1] = new LinkedList<C>();
        super.initializeExploration();
    }

    @Override
    public boolean atEnd() {
        if (this.toSee[this.currentQueueID].isEmpty()) {
            this.currentQueueID = 1 - this.currentQueueID;
            if (this.toSee[this.currentQueueID].isEmpty()) {
                return true;
            }
            ++this.currentDepth;
        }
        return this.currentDepth >= this.targetDepth;
    }

    @Override
    public C nextConfiguration() {
        return (C)((IConfiguration)this.toSee[this.currentQueueID].remove());
    }

    @Override
    public void schedule(C conf) {
        this.setColor(conf, Color.RED);
        this.toSee[1 - this.currentQueueID].add(conf);
    }
}

