/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer;

import announce4j.Announcer;
import java.util.Iterator;
import plug.core.IConfiguration;
import plug.core.IProductAutomaton;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.core.execution.IExecutionMonitor;
import plug.events.CloseConfigurationEvent;
import plug.events.ExecutionEndedEvent;
import plug.events.ExecutionStartedEvent;
import plug.events.FiredEvent;
import plug.events.OpenConfigurationEvent;
import plug.explorer.buchi.nested_dfs.Color;
import plug.statespace.LazyProductAutomaton;

public abstract class AbstractExplorer<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    protected final IStateSpaceManager<C, A> stateSpaceManager;
    protected final IProductAutomaton productAutomaton;
    protected final Announcer announcer = new Announcer(true);

    public AbstractExplorer(ITransitionRelation<C, ?> runtime, IStateSpaceManager<C, A> stateSpaceManager) {
        this.stateSpaceManager = stateSpaceManager;
        this.productAutomaton = new LazyProductAutomaton(runtime, stateSpaceManager, () -> Color.WHITE);
    }

    @Override
    public Announcer getAnnouncer() {
        return this.announcer;
    }

    @Override
    public IStateSpaceManager<C, A> getStateSpaceManager() {
        return this.stateSpaceManager;
    }

    @Override
    public ITransitionRelation getRuntime() {
        return (ITransitionRelation)((Object)this.productAutomaton);
    }

    public IProductAutomaton getProductAutomaton() {
        return this.productAutomaton;
    }

    @Override
    public IExecutionMonitor.Simple getMonitor() {
        return this.monitor;
    }

    abstract boolean atEnd();

    abstract C nextConfiguration();

    abstract void schedule(C var1);

    void initializeExploration() {
        for (IConfiguration initial : this.getProductAutomaton().initialConfigurationsIterable()) {
            this.schedule(initial);
        }
        this.announcer.announce(new ExecutionStartedEvent<C>(this, this.stateSpaceManager.initialConfigurations()));
    }

    @Override
    public void execute() {
        this.initializeExploration();
        while (!this.monitor.atEnd() && !this.atEnd()) {
            this.explorationStep();
        }
        this.announcer.announce(new ExecutionEndedEvent((IExecutionController)this));
    }

    void explorationStep() {
        C source = this.nextConfiguration();
        this.announcer.announce(new OpenConfigurationEvent<C>(this, source));
        this.fire(source);
        this.announcer.announce(new CloseConfigurationEvent<C>(this, source));
    }

    protected void fire(C source) {
        Iterator<C> iterator = this.getProductAutomaton().getPostIterable(source).iterator();
        while (iterator.hasNext()) {
            this.announcer.announce(new FiredEvent(this, ((LazyProductAutomaton.PostIterator)iterator).currentFiredTransition));
            if (this.monitor.atEnd()) {
                this.announcer.announce(new ExecutionEndedEvent((IExecutionController)this));
                return;
            }
            IConfiguration target = (IConfiguration)iterator.next();
            if (this.getColor(target) != Color.WHITE) continue;
            this.schedule(target);
        }
    }

    Color getColor(C state) {
        return (Color)((Object)state.getMetadata());
    }

    void setColor(C state, Color color) {
        state.setMetadata((Object)color);
    }
}

