/*
 * Decompiled with CFR 0.152.
 */
package plug.disk_saving;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigurationDiskStore {
    long PAGE_SIZE = 0x100000L;
    RandomAccessFile file;
    FileChannel fileChannel;
    MappedByteBuffer mem;
    byte[] content = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    int baseAddress = 0;
    Map<byte[], Integer> map = new LinkedHashMap<byte[], Integer>();

    ConfigurationDiskStore(String filepath) {
        try {
            this.file = new RandomAccessFile(filepath, "rw");
            this.fileChannel = this.file.getChannel();
            this.remap(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    MappedByteBuffer remap(int startPosition) {
        try {
            this.mem = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, startPosition, this.PAGE_SIZE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.mem;
    }

    int write(byte[] content) {
        int offset;
        if (this.mem.capacity() - this.mem.position() > content.length + 4) {
            offset = this.mem.position();
        } else {
            this.baseAddress += this.mem.position();
            this.remap(this.baseAddress);
            offset = this.mem.position();
        }
        this.mem.putInt(content.length);
        this.mem.put(content);
        return offset;
    }

    void writeMany() {
        int i;
        for (i = 0; i < 100000; ++i) {
            int offset = this.write(this.content);
            this.map.put((byte[])this.content.clone(), this.baseAddress + offset);
        }
        System.out.println("Content size: " + this.content.length);
        i = 0;
        for (Map.Entry<byte[], Integer> entry : this.map.entrySet()) {
            if (i == 120) {
                System.out.println(entry.getValue());
                try {
                    this.mem = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, entry.getValue().intValue(), 1024L);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println(this.mem.getInt());
                byte[] m = new byte[9];
                this.mem.get(m);
                System.out.println(Arrays.toString(m));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        ConfigurationDiskStore cds = new ConfigurationDiskStore("test.bin");
        cds.writeMany();
    }
}

