/*
 * Decompiled with CFR 0.152.
 */
package plug.language.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;
import plug.core.ILanguageLoader;
import plug.language.remote.RemoteDescription;
import plug.language.remote.RemotePlugin;
import plug.language.remote.runtime.RemoteRuntime;
import plug.utils.exec.ProcessRunner;

public class RemoteLoader
implements ILanguageLoader<RemoteRuntime> {
    public RemoteRuntime getRuntime(URI modelURI, Map<String, Object> options) throws IOException {
        RemoteDescription description = (RemoteDescription)new ObjectMapper().readValue(modelURI.toURL(), RemoteDescription.class);
        int port = description.getPort();
        if (port <= 0) {
            port = RemotePlugin.newPort();
        }
        String[] command = description.getCommand();
        String host = description.getHost();
        if (command != null && command.length > 0) {
            ProcessRunner runner = new ProcessRunner(new PrintWriter(System.out), new PrintWriter(System.err));
            String portString = Integer.toString(port);
            runner.setEnv(new String[]{"PLUG_PORT", portString});
            for (int i = 0; i < command.length; ++i) {
                command[i] = command[i].replaceAll("\\$PLUG_PORT", portString);
            }
            runner.setWorkingPath(Paths.get(modelURI.getPath(), new String[0]).getParent());
            runner.startProcess(command, null);
            host = "localhost";
        }
        RemoteRuntime runtime = new RemoteRuntime(host, port);
        runtime.initializeRuntime();
        return runtime;
    }
}

