/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.graph;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import plug.utils.Pair;
import plug.utils.ui.graph.EdgeView;
import plug.utils.ui.graph.GraphViewModel;
import plug.utils.ui.graph.VertexView;
import plug.utils.ui.graph.layout.PloegTreeLayout;

public class GraphView<V, E>
extends ScrollPane {
    protected double defaultLevelSeparation = 20.0;
    protected double defaultNodeSeparation = 30.0;
    protected double relocateAnimationTiming = 400.0;
    protected BooleanProperty hideAllDetails = new SimpleBooleanProperty(false);
    protected BooleanProperty coloredNodes = new SimpleBooleanProperty(true);
    protected DoubleProperty nodeMaxWidth = new SimpleDoubleProperty(400.0);
    protected DoubleProperty nodeMaxHeight = new SimpleDoubleProperty(200.0);
    protected final Group group = new Group();
    protected final Pane pane = new Pane();
    protected final Group nodeGroup = new Group();
    protected final Group edgeGroup = new Group();
    protected final SimpleObjectProperty<V> selectedVertex = new SimpleObjectProperty(null);
    protected final ObjectProperty<GraphViewModel<V, E>> model = new SimpleObjectProperty();
    private final ListChangeListener<V> onInitialVerticesChanged = this::onInitialVerticesChanged;
    private final ListChangeListener<GraphViewModel.Edge<V, E>> onEdgesChanged = this::onEdgesChanged;
    protected final ObservableList<VertexView<V, E>> initialVertices = FXCollections.observableArrayList();
    protected final ObservableMap<V, VertexView<V, E>> vertexViews = FXCollections.observableMap(new IdentityHashMap());
    protected final ObservableMap<GraphViewModel.Edge<V, E>, EdgeView<V, E>> edgeViews = FXCollections.observableMap(new IdentityHashMap());
    protected final Timeline layoutTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), event -> this.ploegTreeLayout(), new KeyValue[0])});
    BooleanProperty isVertical = new SimpleBooleanProperty(true);
    protected final SimpleBooleanProperty nodeFolding = new SimpleBooleanProperty(true);
    protected final ObservableSet<VertexView> foldedNodes = FXCollections.observableSet((Object[])new VertexView[0]);

    public GraphView() {
        this.pane.getChildren().addAll((Object[])new Node[]{this.edgeGroup, this.nodeGroup});
        this.group.getChildren().add((Object)this.pane);
        this.setContent((Node)this.group);
        this.addEventHandler(ZoomEvent.ZOOM, e -> {
            this.zoom(e.getZoomFactor());
            e.consume();
        });
        this.setPannable(true);
        this.model.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.getInitialVertices().removeListener(this.onInitialVerticesChanged);
                oldValue.getEdges().removeListener(this.onEdgesChanged);
            }
            this.initialVertices.clear();
            this.vertexViews.clear();
            this.edgeViews.clear();
            if (newValue != null) {
                newValue.getInitialVertices().addListener(this.onInitialVerticesChanged);
                newValue.getEdges().addListener(this.onEdgesChanged);
                for (Object initial : newValue.getInitialVertices()) {
                    this.initialVertices.add(this.getOrCreateVertex(initial));
                }
                for (GraphViewModel.Edge edge : newValue.getEdges()) {
                    this.getOrCreateEdgeView(edge);
                }
            }
        });
        this.selectedVertex.addListener(this::selectionChanged);
        this.foldedNodes.addListener(this::foldedNodesUpdate);
        this.vertexViews.addListener(change -> {
            if (change.getValueAdded() != null) {
                this.nodeGroup.getChildren().add(change.getValueAdded());
            }
            if (change.getValueRemoved() != null) {
                this.nodeGroup.getChildren().remove(change.getValueRemoved());
            }
            this.refreshTreeLayout();
        });
        this.edgeViews.addListener(change -> {
            if (change.getValueAdded() != null) {
                this.edgeGroup.getChildren().add(change.getValueAdded());
            }
            if (change.getValueRemoved() != null) {
                this.edgeGroup.getChildren().remove(change.getValueRemoved());
            }
            this.refreshTreeLayout();
        });
        this.isVertical.addListener((a, o, n) -> this.refreshTreeLayout());
    }

    public ObjectProperty<GraphViewModel<V, E>> modelProperty() {
        return this.model;
    }

    public GraphViewModel<V, E> getModel() {
        return (GraphViewModel)this.model.get();
    }

    public void setModel(GraphViewModel<V, E> model) {
        this.model.set(model);
    }

    public SimpleObjectProperty<V> selectedVertexProperty() {
        return this.selectedVertex;
    }

    public V getSelectedVertex() {
        return (V)this.selectedVertex.get();
    }

    public void setSelectedVertex(V selectedVertex) {
        this.selectedVertex.set(selectedVertex);
    }

    public DoubleProperty nodeMaxWidthProperty() {
        return this.nodeMaxWidth;
    }

    public double getNodeMaxWidth() {
        return this.nodeMaxWidth.get();
    }

    public void setNodeMaxWidth(double nodeMaxWidth) {
        this.nodeMaxWidth.set(nodeMaxWidth);
    }

    public DoubleProperty nodeMaxHeightProperty() {
        return this.nodeMaxHeight;
    }

    public double getNodeMaxHeight() {
        return this.nodeMaxHeight.get();
    }

    public void setNodeMaxHeight(double nodeMaxHeight) {
        this.nodeMaxHeight.set(nodeMaxHeight);
    }

    public BooleanProperty hideAllDetailsProperty() {
        return this.hideAllDetails;
    }

    public BooleanProperty coloredNodesProperty() {
        return this.coloredNodes;
    }

    public ObservableSet<VertexView> getFoldedNodes() {
        return this.foldedNodes;
    }

    public void scrollToVertexView(VertexView<V, E> vertex) {
        double width = this.getContent().getBoundsInLocal().getWidth();
        double height = this.getContent().getBoundsInLocal().getHeight();
        double x = vertex.getBoundsInParent().getMaxX();
        double y = vertex.getBoundsInParent().getMaxY();
        this.setVvalue(y / height);
        this.setHvalue(x / width);
    }

    public void actualSize() {
        this.zoom(1.0 / this.pane.getScaleX());
        this.pane.getParent().setTranslateX(0.0);
        this.pane.getParent().setTranslateY(0.0);
    }

    public void zoomToFit() {
        double heightFactor;
        double widthFactor = this.getWidth() / this.pane.getWidth();
        double zoomFactor = widthFactor < (heightFactor = this.getHeight() / this.pane.getHeight()) ? widthFactor : heightFactor;
        this.zoom(zoomFactor / this.pane.getScaleX());
    }

    public void zoom(double zoomFactor) {
        this.pane.setScaleX(this.pane.getScaleX() * zoomFactor);
        this.pane.setScaleY(this.pane.getScaleY() * zoomFactor);
    }

    public void refreshTreeLayout() {
        this.layoutTimeline.playFromStart();
    }

    public VertexView<V, E> buildNodeForVertex(V vertex) {
        VertexView vertexView = new VertexView(this, vertex);
        vertexView.hideDetailsProperty().bind((ObservableValue)this.hideAllDetails);
        vertexView.coloredProperty().bind((ObservableValue)this.coloredNodes);
        return vertexView;
    }

    public BooleanProperty isVerticalProperty() {
        return this.isVertical;
    }

    public void beVertical() {
        this.isVertical.set(true);
    }

    public void beHorizontal() {
        this.isVertical.set(false);
    }

    protected void foldedNodesUpdate(SetChangeListener.Change<? extends VertexView> change) {
        VertexView removed;
        VertexView added = (VertexView)((Object)change.getElementAdded());
        if (added != null) {
            Pair<Set<VertexView<V, E>>, Set<EdgeView<V, E>>> reachable = this.reachableGraphicalElementsFrom(added);
            this.nodeGroup.getChildren().removeAll((Collection)reachable.a);
            this.edgeGroup.getChildren().removeAll((Collection)reachable.b);
        }
        if ((removed = (VertexView)((Object)change.getElementRemoved())) != null) {
            Pair<Set<VertexView<V, E>>, Set<EdgeView<V, E>>> reachable = this.reachableGraphicalElementsFrom(removed);
            this.nodeGroup.getChildren().addAll((Collection)reachable.a);
            this.edgeGroup.getChildren().addAll((Collection)reachable.b);
        }
        this.refreshTreeLayout();
    }

    protected void ploegTreeLayout() {
        PloegTreeLayout layout = new PloegTreeLayout();
        layout.fanoutGetter = this::foldedFanoutGetter;
        if (this.isVertical.get()) {
            layout.positionSetter = this::relocateVertical;
            layout.widthGetter = v -> v.getLayoutBounds().getWidth() + this.defaultNodeSeparation;
            layout.heightGetter = v -> v.getLayoutBounds().getHeight();
        } else {
            layout.positionSetter = this::relocateHorizontal;
            layout.widthGetter = v -> v.getLayoutBounds().getHeight() + this.defaultNodeSeparation;
            layout.heightGetter = v -> v.getLayoutBounds().getWidth();
        }
        layout.defaultLevelSeparation = this.defaultLevelSeparation;
        if (this.initialVertices.size() > 1) {
            layout.layout(this.initialVertices, new VertexView(null, null));
        } else {
            layout.layout(this.initialVertices.stream().findFirst().orElse(null));
        }
    }

    private void relocateHorizontal(VertexView node, double x, double y) {
        this.relocateNode(node, y, x);
    }

    private void relocateVertical(VertexView node, double x, double y) {
        this.relocateNode(node, x, y);
    }

    private void relocateNode(VertexView node, double x, double y) {
        if (this.vertexViews.size() < 500) {
            Timeline timeline = new Timeline();
            timeline.setCycleCount(1);
            KeyValue kv0 = new KeyValue((WritableValue)node.layoutXProperty(), (Object)x);
            KeyValue kv1 = new KeyValue((WritableValue)node.layoutYProperty(), (Object)y);
            KeyFrame kf0 = new KeyFrame(Duration.millis((double)this.relocateAnimationTiming), new KeyValue[]{kv0});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)this.relocateAnimationTiming), new KeyValue[]{kv1});
            timeline.getKeyFrames().add((Object)kf0);
            timeline.getKeyFrames().add((Object)kf1);
            timeline.play();
        } else {
            node.layoutXProperty().set(x);
            node.layoutYProperty().set(y);
        }
    }

    public BooleanProperty nodeFoldingProperty() {
        return this.nodeFolding;
    }

    public void setNodeFolding(boolean nodeFolding) {
        this.nodeFolding.set(nodeFolding);
    }

    protected Pair<Set<VertexView<V, E>>, Set<EdgeView<V, E>>> reachableGraphicalElementsFrom(VertexView<V, E> v) {
        LinkedList<VertexView<V, E>> toSee = new LinkedList<VertexView<V, E>>();
        Set known = Collections.newSetFromMap(new IdentityHashMap());
        Pair result = new Pair(Collections.newSetFromMap(new IdentityHashMap()), Collections.newSetFromMap(new IdentityHashMap()));
        toSee.add(v);
        while (!toSee.isEmpty()) {
            VertexView source = (VertexView)((Object)toSee.remove());
            for (EdgeView<V, E> edge : this.edgeViewsFrom(source)) {
                if (known.add(edge.getTarget())) {
                    if (!this.foldedNodes.contains(edge.getTarget())) {
                        toSee.add(edge.getTarget());
                    }
                    ((Set)result.a).add(edge.getTarget());
                }
                ((Set)result.b).add(edge);
            }
        }
        return result;
    }

    protected List<VertexView<V, E>> foldedFanoutGetter(VertexView<V, E> v) {
        if (this.foldedNodes.contains(v)) {
            return Collections.emptyList();
        }
        return this.edgeViewsFrom(v).stream().map(e -> e.target).collect(Collectors.toList());
    }

    protected void onInitialVerticesChanged(ListChangeListener.Change<? extends V> change) {
        Platform.runLater(() -> {
            change.reset();
            while (change.next()) {
                for (Object toAdd : change.getAddedSubList()) {
                    this.initialVertices.add(this.getOrCreateVertex(toAdd));
                }
                for (Object toRemove : change.getRemoved()) {
                    VertexView vertex = this.removeVertexIfExists(toRemove);
                    this.initialVertices.remove(vertex);
                }
            }
        });
    }

    protected void onEdgesChanged(ListChangeListener.Change<? extends GraphViewModel.Edge<V, E>> change) {
        Platform.runLater(() -> {
            change.reset();
            while (change.next()) {
                for (GraphViewModel.Edge toRemove : change.getRemoved()) {
                    this.removeEdgeViewIfExists(toRemove);
                }
                for (GraphViewModel.Edge toAdd : change.getAddedSubList()) {
                    this.getOrCreateEdgeView(toAdd);
                }
            }
            this.updateVerticesColor();
        });
    }

    protected VertexView<V, E> getOrCreateVertex(V toAdd) {
        return (VertexView)((Object)this.vertexViews.computeIfAbsent(toAdd, a -> this.buildNodeForVertex(toAdd)));
    }

    protected VertexView<V, E> removeVertexIfExists(V toRemove) {
        VertexView vertex = (VertexView)((Object)this.vertexViews.remove(toRemove));
        if (vertex != null) {
            this.nodeGroup.getChildren().remove((Object)vertex);
            if (this.selectedVertexProperty().get() == toRemove) {
                this.selectedVertexProperty().set(null);
            }
        }
        return vertex;
    }

    protected EdgeView<V, E> getOrCreateEdgeView(GraphViewModel.Edge<V, E> edge) {
        VertexView sourceView = this.getOrCreateVertex(edge.source);
        VertexView targetView = this.getOrCreateVertex(edge.target);
        EdgeView<V, E> edgeView = new EdgeView<V, E>(this, edge);
        this.edgeViews.put(edge, edgeView);
        return edgeView;
    }

    protected EdgeView<V, E> removeEdgeViewIfExists(GraphViewModel.Edge<? extends V, ? extends E> edge) {
        this.removeVertexIfExists(edge.target);
        return (EdgeView)((Object)this.edgeViews.remove(edge));
    }

    public List<EdgeView<V, E>> edgeViewsFrom(VertexView<V, E> source) {
        return this.edgeViews.entrySet().stream().filter(e -> ((GraphViewModel.Edge)e.getKey()).source == source.getData()).map(e -> (EdgeView)((Object)((Object)e.getValue()))).collect(Collectors.toList());
    }

    protected void updateVerticesColor() {
        GraphViewModel model = (GraphViewModel)this.model.get();
        for (VertexView vertexView : this.vertexViews.values()) {
            vertexView.setColor(model.vertexColor(vertexView.getData()));
        }
    }

    private void selectionChanged(ObservableValue<? extends V> observable, V oldValue, V newValue) {
        Platform.runLater(() -> {
            if (oldValue != null) {
                for (Object equivalent : ((GraphViewModel)this.model.get()).equivalentVertices(oldValue)) {
                    VertexView view = (VertexView)((Object)((Object)this.vertexViews.get(equivalent)));
                    if (view == null) continue;
                    view.selectedProperty().set(false);
                }
                if (this.vertexViews.containsKey(oldValue)) {
                    ((VertexView)((Object)((Object)this.vertexViews.get(oldValue)))).selectedProperty().set(false);
                }
            }
            if (newValue != null) {
                for (Object equivalent : ((GraphViewModel)this.model.get()).equivalentVertices(newValue)) {
                    ((VertexView)((Object)((Object)this.vertexViews.get(equivalent)))).selectedProperty().set(true);
                }
                VertexView vertexView = (VertexView)((Object)((Object)this.vertexViews.get(newValue)));
                if (vertexView != null) {
                    vertexView.selectedProperty().set(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePngImage(File imageFile) throws IOException {
        double previousScaleX = this.pane.getScaleX();
        double previousScaleY = this.pane.getScaleY();
        try {
            this.pane.setScaleX(2.0);
            this.pane.setScaleY(2.0);
            SnapshotParameters params = new SnapshotParameters();
            params.setFill((Paint)Color.valueOf((String)"#f1f1f1"));
            WritableImage image = this.pane.snapshot(params, null);
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", imageFile);
        }
        finally {
            this.pane.setScaleX(previousScaleX);
            this.pane.setScaleY(previousScaleY);
        }
    }
}

