/*
 * Decompiled with CFR 0.152.
 */
package properties.BuchiAutomata.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import properties.BuchiAutomata.BuchiAutomataModel.Automaton;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.BuchiAutomata.BuchiAutomataModel.util.BuchiAutomataModelSwitch;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;

public class AtomExtractor {
    public List<Atom> getAtoms(BuchiDeclaration buchiDeclaration) {
        Extractor extractor = new Extractor();
        extractor.doSwitch(buchiDeclaration);
        return extractor.atoms;
    }

    class Extractor
    extends BuchiAutomataModelSwitch<Boolean> {
        properties.PropositionalLogic.transformations.AtomExtractor extractor = new properties.PropositionalLogic.transformations.AtomExtractor();
        Set<EObject> known = Collections.newSetFromMap(new IdentityHashMap());
        List<Atom> atoms = new ArrayList<Atom>();

        Extractor() {
        }

        @Override
        public Boolean caseAutomaton(Automaton object) {
            if (this.known.contains(object)) {
                return true;
            }
            for (GuardedTransition transition : object.getTransitions()) {
                this.atoms.addAll(this.extractor.getAtoms(transition.getGuard(), this.known));
            }
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseBuchiDeclaration(BuchiDeclaration object) {
            if (this.known.contains(object)) {
                return true;
            }
            for (Declaration decl : object.getDeclarations()) {
                this.atoms.addAll(this.extractor.getAtoms(decl, this.known));
            }
            this.doSwitch(object.getAutomaton());
            this.known.add(object);
            return true;
        }
    }
}

