/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javafx.scene.control.IndexRange;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowExt
extends TextFlow {
    private static Method mGetTextLayout;

    TextFlowExt() {
    }

    private static Object invoke(Method m, Object obj, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    int getLineCount() {
        return this.getLines().length;
    }

    int getLineStartPosition(int charIdx) {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
        return navigator.position(currentLineIndex, 0).toOffset();
    }

    int getLineEndPosition(int charIdx) {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
        int minor = currentLineIndex == lines.length - 1 ? 0 : -1;
        return navigator.position(currentLineIndex + 1, minor).toOffset();
    }

    int getLineOfCharacter(int charIdx) {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        return navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
    }

    PathElement[] getCaretShape(int charIdx, boolean isLeading) {
        return this.textLayout().getCaretShape(charIdx, isLeading, 0.0f, 0.0f);
    }

    PathElement[] getRangeShape(IndexRange range) {
        return this.getRangeShape(range.getStart(), range.getEnd());
    }

    PathElement[] getRangeShape(int from, int to) {
        return this.textLayout().getRange(from, to, 1, 0.0f, 0.0f);
    }

    PathElement[] getUnderlineShape(IndexRange range) {
        return this.getUnderlineShape(range.getStart(), range.getEnd());
    }

    PathElement[] getUnderlineShape(int from, int to) {
        PathElement[] shape = this.textLayout().getRange(from, to, 2, 0.0f, 0.0f);
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        boolean collect = false;
        for (PathElement elem : shape) {
            if (elem instanceof MoveTo) {
                result.add(elem);
                collect = true;
                continue;
            }
            if (!(elem instanceof LineTo) || !collect) continue;
            result.add(elem);
            collect = false;
        }
        return result.toArray(new PathElement[0]);
    }

    CharacterHit hitLine(double x, int lineIndex) {
        return this.hit(x, this.getLineCenter(lineIndex));
    }

    CharacterHit hit(double x, double y) {
        HitInfo hit = this.textLayout().getHitInfo((float)x, (float)y);
        int charIdx = hit.getCharIndex();
        boolean leading = hit.isLeading();
        int lineIdx = this.getLineIndex((float)y);
        if (lineIdx >= this.getLineCount()) {
            return CharacterHit.insertionAt(this.getCharCount());
        }
        TextLine[] lines = this.getLines();
        TextLine line = lines[lineIdx];
        RectBounds lineBounds = line.getBounds();
        if (lines.length > 1 && lineIdx < lines.length - 1 && charIdx + 1 >= line.getStart() + line.getLength() && !leading) {
            leading = true;
        }
        if (x < (double)lineBounds.getMinX() || x > (double)lineBounds.getMaxX()) {
            if (leading) {
                return CharacterHit.insertionAt(charIdx);
            }
            return CharacterHit.insertionAt(charIdx + 1);
        }
        if (leading) {
            return CharacterHit.leadingHalfOf(charIdx);
        }
        return CharacterHit.trailingHalfOf(charIdx);
    }

    private float getLineY(int index) {
        TextLine[] lines = this.getLines();
        float spacing = (float)this.getLineSpacing();
        float lineY = 0.0f;
        for (int i = 0; i < index; ++i) {
            lineY += lines[i].getBounds().getHeight() + spacing;
        }
        return lineY;
    }

    private float getLineCenter(int index) {
        return this.getLineY(index) + this.getLines()[index].getBounds().getHeight() / 2.0f;
    }

    private TextLine[] getLines() {
        return this.textLayout().getLines();
    }

    private int getLineIndex(float y) {
        return this.textLayout().getLineIndex(y);
    }

    private int getCharCount() {
        return this.textLayout().getCharCount();
    }

    private TextLayout textLayout() {
        return GenericIceBreaker.proxy(TextLayout.class, TextFlowExt.invoke(mGetTextLayout, (Object)this, new Object[0]));
    }

    static {
        try {
            mGetTextLayout = TextFlow.class.getDeclaredMethod("getTextLayout", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        mGetTextLayout.setAccessible(true);
    }

    private static interface HitInfo {
        public int getCharIndex();

        public boolean isLeading();
    }

    private static interface RectBounds {
        public float getMinX();

        public float getMaxX();

        public float getHeight();
    }

    private static interface TextLine {
        public int getLength();

        public RectBounds getBounds();

        public int getStart();
    }

    private static interface TextLayout {
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_UNDERLINE = 2;

        public TextLine[] getLines();

        public int getLineIndex(float var1);

        public int getCharCount();

        public HitInfo getHitInfo(float var1, float var2);

        public PathElement[] getCaretShape(int var1, boolean var2, float var3, float var4);

        public PathElement[] getRange(int var1, int var2, int var3, float var4, float var5);
    }

    private static class MethodCacheKey {
        final Class<?> cls;
        final String name;
        final Class<?>[] paramTypes;

        MethodCacheKey(Class<?> cls, String name, Class<?> ... paramTypes) {
            this.cls = cls;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodCacheKey)) {
                return false;
            }
            MethodCacheKey key2 = (MethodCacheKey)obj;
            return this.cls == key2.cls && this.name.equals(key2.name) && Arrays.equals(this.paramTypes, key2.paramTypes);
        }

        public int hashCode() {
            return this.cls.hashCode() + this.name.hashCode() + Arrays.hashCode(this.paramTypes);
        }
    }

    private static class GenericIceBreaker
    implements InvocationHandler {
        private final Object delegate;
        private static final HashMap<MethodCacheKey, Method> declaredMethodCache = new HashMap();

        private GenericIceBreaker(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method delegateMethod = GenericIceBreaker.getDeclaredMethod(this.delegate.getClass(), method.getName(), method.getParameterTypes());
            Object delegateMethodReturn = null;
            try {
                delegateMethodReturn = delegateMethod.invoke(this.delegate, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("problems invoking " + method.getName());
            }
            if (delegateMethodReturn == null) {
                return null;
            }
            if (method.getReturnType().isArray() && method.getReturnType().getComponentType().isInterface() && !method.getReturnType().getComponentType().equals(delegateMethod.getReturnType().getComponentType())) {
                int arrayLength = Array.getLength(delegateMethodReturn);
                Object retArray = Array.newInstance(method.getReturnType().getComponentType(), arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    Array.set(retArray, i, GenericIceBreaker.proxy(method.getReturnType().getComponentType(), Array.get(delegateMethodReturn, i)));
                }
                return retArray;
            }
            if (method.getReturnType().isInterface() && !method.getReturnType().equals(delegateMethod.getReturnType())) {
                return GenericIceBreaker.proxy(method.getReturnType(), delegateMethodReturn);
            }
            return delegateMethodReturn;
        }

        static <T> T proxy(Class<T> iface, Object delegate) {
            return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new GenericIceBreaker(delegate));
        }

        private static synchronized Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... paramTypes) throws NoSuchMethodException, SecurityException {
            MethodCacheKey methodCacheKey = new MethodCacheKey(cls, name, paramTypes);
            Method m = declaredMethodCache.get(methodCacheKey);
            if (m == null) {
                m = cls.getDeclaredMethod(name, paramTypes);
                m.setAccessible(true);
                declaredMethodCache.put(methodCacheKey, m);
            }
            return m;
        }
    }
}

