/*
 * Decompiled with CFR 0.152.
 */
package plug.partially_bounded;

import announce4j.Announcer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import plug.core.IFiredTransition;
import plug.core.IProductAutomaton;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.core.execution.IExecutionMonitor;
import plug.events.CloseConfigurationEvent;
import plug.events.ExecutionEndedEvent;
import plug.events.ExecutionStartedEvent;
import plug.events.FiredEvent;
import plug.events.OpenConfigurationEvent;
import plug.partially_bounded.IDepthChangeDetector;
import plug.statespace.configurations.FullConfigurationStorage;

public class PartiallyBoundedExplorer<C, A>
implements IExecutionController {
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    protected final FullConfigurationStorage stateSpaceManager;
    protected final ITransitionRelation runtime;
    public final Announcer announcer = new Announcer(true);
    protected final int targetDepth;
    protected int currentDepth;
    protected Queue toSee;
    protected FullConfigurationStorage nextStage;

    public PartiallyBoundedExplorer(ITransitionRelation runtime, int targetDepth) {
        this.runtime = runtime;
        this.stateSpaceManager = new FullConfigurationStorage();
        this.stateSpaceManager.setStorageBackend(new HashMap());
        this.targetDepth = targetDepth;
    }

    @Override
    public Announcer getAnnouncer() {
        return this.announcer;
    }

    @Override
    public IStateSpaceManager<C, A> getStateSpaceManager() {
        return null;
    }

    @Override
    public ITransitionRelation getRuntime() {
        return this.runtime;
    }

    public IProductAutomaton getProductAutomaton() {
        return null;
    }

    @Override
    public IExecutionMonitor.Simple getMonitor() {
        return this.monitor;
    }

    void initializeExploration() {
        this.nextStage = new FullConfigurationStorage();
        this.nextStage.setStorageBackend(new HashMap());
        Set initialConfigurations = this.getRuntime().initialConfigurations();
        this.announcer.announce(new ExecutionStartedEvent(this, initialConfigurations));
        this.currentDepth = 0;
        this.toSee = new LinkedList();
        this.toSee.addAll(initialConfigurations);
    }

    @Override
    public void execute() {
        this.initializeExploration();
        while (!this.atEnd()) {
            this.explorationStep();
        }
        this.announcer.announce(new ExecutionEndedEvent((IExecutionController)this));
    }

    void explorationStep() {
        Object source = this.nextConfiguration();
        this.announcer.announce(new OpenConfigurationEvent<Object>(this, source));
        this.stateSpaceManager.put(source);
        Collection<?> fireable = this.getFireableTransitions(source);
        this.fire(fireable, source);
        this.announcer.announce(new CloseConfigurationEvent<Object>(this, source));
    }

    void fire(Collection<?> fireable, Object source) {
        for (Object transition : fireable) {
            if (this.monitor.atEnd()) {
                return;
            }
            IFiredTransition<Object, ?> fired = this.getRuntime().fireOneTransition(source, transition);
            if (fired == null || fired.getTargets().isEmpty()) continue;
            this.announcer.announce(new FiredEvent(this, fired));
            if (!this.depthChanges(fired)) {
                if (this.stateSpaceManager.contains(fired.getTarget(0))) continue;
                this.scheduleNow(fired.getTarget(0));
                continue;
            }
            this.scheduleNext(fired.getTarget(0));
        }
    }

    boolean depthChanges(IFiredTransition transition) {
        return ((IDepthChangeDetector)((Object)this.getRuntime())).depthChanges(transition);
    }

    Collection<?> getFireableTransitions(Object source) {
        return this.getRuntime().fireableTransitionsFrom(source);
    }

    public boolean atEnd() {
        if (this.toSee.isEmpty()) {
            this.stateSpaceManager.setStorageBackend(new HashMap());
            if (this.nextStage.size() == 0) {
                return true;
            }
            this.toSee.addAll(this.nextStage.getConfigurations());
            System.out.println("depth " + this.currentDepth);
            ++this.currentDepth;
        }
        return this.currentDepth >= this.targetDepth;
    }

    public Object nextConfiguration() {
        return this.toSee.remove();
    }

    void scheduleNow(Object conf) {
        this.toSee.add(conf);
    }

    void scheduleNext(Object conf) {
        this.nextStage.put(conf);
    }
}

