/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.ui;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.stage.FileChooser;
import plug.core.ILanguagePlugin;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.core.fx.IAppContext;
import plug.core.registry.LanguageModuleRegistry;
import plug.ui2.model_view.ModelEditor;
import plug.ui2.simulation.SimulationView;
import plug.utils.file.FileWatcher;

public class SimulationMainView<C, T>
extends SplitPane {
    ObjectProperty<Path> modelPath = new SimpleObjectProperty();
    BooleanProperty modelChanged = new SimpleBooleanProperty(false);
    FileWatcher watcher;
    ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty = new SimpleObjectProperty();
    ObjectProperty<IRuntimeView<C, T>> runtimeViewProperty = new SimpleObjectProperty();
    ObjectProperty<Set<C>> initialSetProperty = new SimpleObjectProperty();

    public SimulationMainView(IAppContext appContext) {
        this.watcher = appContext.getFileWatcher();
        this.modelPath.addListener(this::modelChangedCallback);
        ModelEditor modelUnderVerificationView = new ModelEditor("Model", this.modelPath, this.modelChanged, this.modelExtensionFilters());
        this.modelChanged.addListener((a, o, n) -> this.updateSimulationView());
        this.setOrientation(Orientation.VERTICAL);
        this.setDividerPosition(0, 0.5);
        this.getItems().addAll((Object[])new Node[]{modelUnderVerificationView, this.createSimulationView()});
    }

    SimulationView<C, T> createSimulationView() {
        return new SimulationView<C, T>(this.transitionRelationProperty, this.runtimeViewProperty, this.initialSetProperty);
    }

    public void updateSimulationView() {
        ITransitionRelation transitionRelation;
        if (this.modelPath.get() == null) {
            this.transitionRelationProperty.set(null);
            this.runtimeViewProperty.set(null);
            this.initialSetProperty.set(null);
            return;
        }
        ILanguagePlugin plugin = LanguageModuleRegistry.getInstance().getModuleByExtension((Path)this.modelPath.get());
        try {
            transitionRelation = plugin.getLoader().getRuntime(((Path)this.modelPath.get()).toUri(), null);
            this.transitionRelationProperty.set((Object)transitionRelation);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (transitionRelation == null) {
            return;
        }
        this.runtimeViewProperty.set((Object)plugin.getRuntimeView(transitionRelation));
        this.initialSetProperty.set((Object)transitionRelation.initialConfigurations());
        this.getItems().remove(1);
        this.getItems().add(this.createSimulationView());
    }

    public void modelChangedCallback(ObservableValue<? extends Path> obj, Path oldP, Path newP) {
        this.watcher.removePathListener(oldP);
        this.watcher.addOnContentChange(newP, c -> Platform.runLater(() -> this.modelChanged.set(!this.modelChanged.get())));
        this.modelChanged.set(!this.modelChanged.get());
    }

    public Collection<FileChooser.ExtensionFilter> modelExtensionFilters() {
        ArrayList<FileChooser.ExtensionFilter> extensionFilters = new ArrayList<FileChooser.ExtensionFilter>();
        for (ILanguagePlugin languageModule : LanguageModuleRegistry.getInstance().getModules()) {
            if (languageModule.getName().equals("Buchi")) continue;
            List extensions = Stream.of(languageModule.getExtensions()).map(e -> "*" + e).collect(Collectors.toList());
            extensionFilters.add(new FileChooser.ExtensionFilter(languageModule.getName(), extensions));
        }
        return extensionFilters;
    }
}

