/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.trace;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IFiredTransition;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.simulation.trace_storage.TraceEntry;
import plug.simulation.trace_storage.TraceStore;
import plug.ui2.simulation.trace.SimulationGraphViewModel;
import plug.utils.ui.graph.GraphView;

public class BranchingTraceView<C, T>
extends BorderPane {
    ObjectProperty<TraceStore<C, Object>> traceStoreProperty;
    GraphView<TraceEntry<C, Object>, Object> graphView;
    SimulationGraphViewModel<C, T> graphViewModel;
    ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty;
    ObjectProperty<IRuntimeView<C, T>> runtimeViewProperty;
    BooleanProperty isFirst = new SimpleBooleanProperty(true);

    public BranchingTraceView(ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty, ObjectProperty<IRuntimeView<C, T>> runtimeViewProperty, ObjectProperty<IFiredTransition<C, ?>> inFiredTransition, ObjectProperty<TraceStore<C, Object>> inoutTraceStore, ObjectProperty<TraceEntry<C, Object>> outCurrentEntry, Function<TraceEntry<C, T>, Node> configurationViewBuilder) {
        this.graphView = new GraphView();
        this.graphView.setPrefSize(400.0, 300.0);
        this.graphViewModel = new SimulationGraphViewModel<C, T>(transitionRelationProperty, runtimeViewProperty, configurationViewBuilder);
        this.graphView.setModel(this.graphViewModel);
        this.traceStoreProperty = inoutTraceStore;
        TraceStore traceStore = (TraceStore)this.traceStoreProperty.get();
        if (traceStore == null) {
            traceStore = new TraceStore();
            this.traceStoreProperty.set((Object)traceStore);
        }
        traceStore.setAddRootUserCallback(this::addRootCallback);
        traceStore.setAddStepUserCallback(this::addStepCallback);
        traceStore.iterateOverTrace();
        this.graphView.setSelectedVertex((Object)traceStore.getLastEntry());
        if (traceStore.getLastEntry() != null) {
            outCurrentEntry.set((Object)traceStore.getLastEntry());
        }
        this.transitionRelationProperty = transitionRelationProperty;
        this.runtimeViewProperty = runtimeViewProperty;
        this.graphView.setNodeFolding(true);
        this.graphView.beHorizontal();
        this.setCenter((Node)this.graphView);
        ToggleButton hideDetailsButton = new ToggleButton(null, (Node)new FontIcon("gmi-photo-size-select-small"));
        hideDetailsButton.setTooltip(new Tooltip("Show/hide details in configurations"));
        hideDetailsButton.selectedProperty().bindBidirectional((Property)this.graphView.hideAllDetailsProperty());
        ToggleButton coloredButton = new ToggleButton(null, (Node)new FontIcon("gmi-color-lens"));
        coloredButton.setTooltip(new Tooltip("Show/hide colors of configurations"));
        coloredButton.selectedProperty().bindBidirectional((Property)this.graphView.coloredNodesProperty());
        ToggleButton orientationButton = new ToggleButton(null, (Node)new FontIcon("gmi-screen-rotation"));
        orientationButton.setTooltip(new Tooltip("Change trace orientation"));
        orientationButton.selectedProperty().bindBidirectional((Property)this.graphView.isVerticalProperty());
        Button saveImageButton = new Button(null, (Node)new FontIcon("gmi-save"));
        saveImageButton.setTooltip(new Tooltip("Save an image of the current trace"));
        saveImageButton.setOnAction(event -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select file where to save image");
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG image", new String[]{"*.png"}));
            File file = chooser.showSaveDialog(this.getScene().getWindow());
            if (file != null) {
                try {
                    this.graphView.savePngImage(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        HBox toolkitPane = new HBox(5.0, new Node[]{hideDetailsButton, coloredButton, orientationButton, new Separator(Orientation.VERTICAL), saveImageButton});
        toolkitPane.setPadding(new Insets(5.0));
        this.setBottom((Node)toolkitPane);
        this.graphView.selectedVertexProperty().addListener((a, o, n) -> {
            if (n == null) {
                outCurrentEntry.set(null);
                return;
            }
            outCurrentEntry.set(n);
        });
        inFiredTransition.addListener((a, o, n) -> {
            TraceEntry sourceEntry = (TraceEntry)this.graphView.getSelectedVertex();
            TraceEntry firstBranch = null;
            for (Object target : n.getTargets()) {
                TraceEntry targetEntry = ((TraceStore)this.traceStoreProperty.get()).addStep(sourceEntry, target, n.getAction());
                if (firstBranch != null) continue;
                firstBranch = targetEntry;
            }
            this.graphView.setSelectedVertex(firstBranch);
        });
    }

    public void setInitialConfigurations(Set<C> initialConfigurations) {
        ((TraceStore)this.traceStoreProperty.get()).addRoots(initialConfigurations);
    }

    public void setCounterExample(List<C> counterExample) {
        TraceEntry entry = ((TraceStore)this.traceStoreProperty.get()).addSteps((TraceEntry)this.graphView.getSelectedVertex(), counterExample, (arg_0, arg_1) -> ((ITransitionRelation)((ITransitionRelation)this.transitionRelationProperty.get())).actionFromSourceToTarget(arg_0, arg_1));
        this.graphView.setSelectedVertex((Object)entry);
    }

    void addStepCallback(TraceEntry<C, Object> entry) {
        this.graphViewModel.addEdge(entry.getParent(), entry, entry.getAction());
    }

    void addRootCallback(TraceEntry<C, Object> entry) {
        this.graphViewModel.getInitialVertices().add(entry);
        if (this.isFirst.get()) {
            this.graphView.setSelectedVertex(entry);
            this.isFirst.set(false);
        }
    }
}

