/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.model_view;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import plug.code_editor.richtextfx.FiacreStyler;
import plug.code_editor.richtextfx.GPSLPropertyStyler;
import plug.code_editor.richtextfx.TLAStyler;

public class CodeEditor
extends StackPane {
    final KeyCombination saveKeyCombination = new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final CodeArea codeArea;
    ObjectProperty<Path> pathProperty;
    private Function<String, StyleSpans<Collection<String>>> styler;

    private Function<String, StyleSpans<Collection<String>>> defaultStyler() {
        FiacreStyler fcrStyler = new FiacreStyler();
        return fcrStyler::computeHighlighting;
    }

    public CodeEditor(ObjectProperty<Path> pathProperty, BooleanProperty modelChanged) {
        this(pathProperty, modelChanged, null);
    }

    public CodeEditor(ObjectProperty<Path> pathProperty, BooleanProperty modelChanged, Function<String, StyleSpans<Collection<String>>> styler) {
        this.pathProperty = pathProperty;
        this.styler = styler;
        this.codeArea = new CodeArea();
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeArea));
        pathProperty.addListener((observable, oldValue, newValue) -> this.updateText(this.readFile((Path)newValue)));
        modelChanged.addListener((observable, oldValue, newValue) -> this.updateText(this.readFile((Path)pathProperty.get())));
        this.updateText(this.readFile((Path)pathProperty.get()));
        VirtualizedScrollPane scrollPane = new VirtualizedScrollPane((Node)this.codeArea);
        this.getChildren().add((Object)scrollPane);
        this.getStylesheets().add((Object)CodeEditor.class.getResource("java-keywords.css").toExternalForm());
        this.setOnKeyPressed(event -> {
            if (event.isMetaDown() && event.getText().equals("z")) {
                this.codeArea.undo();
            }
            if (event.isMetaDown() && event.isShiftDown() && event.getText().equals("z")) {
                this.codeArea.redo();
            }
        });
        this.codeArea.addEventHandler(KeyEvent.KEY_RELEASED, this::saveKeyCombinationHandler);
    }

    protected void updateText(String text) {
        this.codeArea.replaceText(text);
        this.codeArea.setStyleSpans(0, this.styler == null ? this.defaultStyler().apply(this.codeArea.getText()) : this.styler.apply(this.codeArea.getText()));
        this.codeArea.getUndoManager().forgetHistory();
        this.codeArea.moveTo(0);
        this.codeArea.requestFollowCaret();
    }

    void saveKeyCombinationHandler(KeyEvent e) {
        if (this.saveKeyCombination.match(e)) {
            String text = this.codeArea.getText();
            try {
                Path savePath = (Path)this.pathProperty.get();
                if (savePath == null) {
                    FileChooser chooser = new FileChooser();
                    File file = chooser.showSaveDialog(this.getScene().getWindow());
                    if (file == null) {
                        return;
                    }
                    savePath = file.toPath();
                }
                Files.write(savePath, text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.pathProperty.set((Object)savePath);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    String readFile(Path path) {
        if (path == null) {
            return "";
        }
        try {
            this.styler = path.getFileName().toString().endsWith(".tla") ? new TLAStyler()::computeHighlighting : (path.getFileName().toString().endsWith(".gpsl") ? new GPSLPropertyStyler()::computeHighlighting : new FiacreStyler()::computeHighlighting);
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "unsupported file type";
        }
    }
}

