/*
 * Decompiled with CFR 0.152.
 */
package plug.code_editor.richtextfx;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class GPSLPropertyStyler {
    private static final String[] KEYWORDS = new String[]{"and", "or", "iff", "implies", "not", "xor", "eventually", "F", "globally", "G", "always", "next", "N", "until", "U", "W", "M", "R", "let", "in", "states", "initial", "accept", "true", "false"};
    private static final String[] KEYWORDS2 = new String[]{"&", "&&", "/\\\\", "\\*", "\\|\\|", "\\\\/", "\\+", "<->", "<=>", "->", "=>", "\\!", "\\~", "\\^", "<>", "\\[\\]", "\\(\\)"};
    private static final String IDENTIFIER_PATTERN = "[a-zA-Z][a-zA-Z_0-9]*";
    private static final String KEYWORD_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS) + ")\\b";
    private static final String PAREN_PATTERN = "\\(|\\)";
    private static final String BRACKET_PATTERN = "\\[|\\]";
    private static final String SEMICOLON_PATTERN = "\\,";
    private static final String STRING_PATTERN = "\\|([^\\|\\\\]|\\\\.)*\\|";
    private static final String COMMENT_PATTERN = "//[^\n]*|/\\*(.|\\R)*?\\*/";
    private static final Pattern PATTERN = Pattern.compile("(?<KEYWORD>" + KEYWORD_PATTERN + "|" + String.join((CharSequence)"|", KEYWORDS2) + ")|(?<PAREN>" + "\\(|\\)" + ")|(?<BRACKET>" + "\\[|\\]" + ")|(?<SEMICOLON>" + "\\," + ")|(?<STRING>" + "\\|([^\\|\\\\]|\\\\.)*\\|" + ")|(?<COMMENT>" + "//[^\n]*|/\\*(.|\\R)*?\\*/" + ")|(?<IDENTIFIER>" + "[a-zA-Z][a-zA-Z_0-9]*" + ")[ |\t]*=");

    public StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("KEYWORD") != null ? "keyword" : (matcher.group("PAREN") != null ? "paren" : (matcher.group("BRACKET") != null ? "bracket" : (matcher.group("SEMICOLON") != null ? "semicolon" : (matcher.group("STRING") != null ? "string" : (matcher.group("COMMENT") != null ? "comment" : (styleClass = matcher.group("IDENTIFIER") != null ? "identifier" : null))))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }
}

