/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.grammar.PropositionalLogicBaseListener;
import properties.PropositionalLogic.grammar.PropositionalLogicParser;
import properties.PropositionalLogic.parser.TreeAnnotator;

public class SymbolResolver
extends PropositionalLogicBaseListener
implements TreeAnnotator {
    public ParseTreeProperty<Object> values;
    Stack<Map<String, Declaration>> scopes = new Stack();

    public SymbolResolver(ParseTreeProperty<Object> ast) {
        this(ast, null);
    }

    public SymbolResolver(ParseTreeProperty<Object> ast, Map<String, Declaration> globalScope) {
        this.values = ast;
        if (globalScope != null) {
            this.scopes.push(globalScope);
        }
    }

    @Override
    public ParseTreeProperty<Object> getValues() {
        return this.values;
    }

    public Map<String, Declaration> currentScope() {
        return this.scopes.peek();
    }

    public Declaration resolve(String name) {
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            Declaration value = (Declaration)((Map)this.scopes.get(i)).get(name);
            if (value == null) continue;
            return value;
        }
        throw new SymbolMissingException("Symbol " + name + " is not present in scope");
    }

    public void define(String symbol, Declaration value) {
        Declaration previousDeclaration = this.currentScope().get(symbol);
        if (previousDeclaration == null) {
            this.currentScope().put(symbol, value);
            return;
        }
        throw new SymbolRedefinitionException("Illegal redefinition of " + symbol + "[" + previousDeclaration.getClass().getSimpleName() + "] as " + value.getClass().getSimpleName());
    }

    public Map<String, Declaration> pushNewScope() {
        HashMap newScope = new HashMap();
        return this.scopes.push(newScope);
    }

    public Map<String, Declaration> popScope() {
        if (this.scopes.size() < 1) {
            throw new RuntimeException("Empty scope stack, cannot pop the scope");
        }
        return this.scopes.pop();
    }

    @Override
    public void enterLetExp(PropositionalLogicParser.LetExpContext ctx) {
        this.pushNewScope();
    }

    @Override
    public void exitLetExp(PropositionalLogicParser.LetExpContext ctx) {
        this.popScope();
    }

    @Override
    public void enterBlock(PropositionalLogicParser.BlockContext ctx) {
        this.pushNewScope();
    }

    @Override
    public void exitBlock(PropositionalLogicParser.BlockContext ctx) {
        this.popScope();
    }

    @Override
    public void exitFormulaDeclaration(PropositionalLogicParser.FormulaDeclarationContext ctx) {
        String symbol = ctx.IDENTIFIER().getText();
        ExpressionDeclaration astNode = (ExpressionDeclaration)this.getValue((ParseTree)ctx, ExpressionDeclaration.class);
        this.define(symbol, astNode);
    }

    @Override
    public void exitReferenceExp(PropositionalLogicParser.ReferenceExpContext ctx) {
        Declaration declaration = this.resolve(ctx.IDENTIFIER().getText());
        if (!(declaration instanceof ExpressionDeclaration)) {
            throw new InvalidDeclarationTypeException("The declared identifier " + declaration.getName() + "[" + declaration.getClass().getSimpleName() + "] is not an instance of " + ExpressionDeclaration.class.getSimpleName());
        }
        ExpressionReference ref = (ExpressionReference)this.getValue((ParseTree)ctx, ExpressionReference.class);
        ref.setExp((ExpressionDeclaration)declaration);
    }

    public static class InvalidDeclarationTypeException
    extends RuntimeException {
        private static final long serialVersionUID = -5373544148436894156L;

        public InvalidDeclarationTypeException(String string) {
            super(string);
        }
    }

    public static class SymbolRedefinitionException
    extends RuntimeException {
        private static final long serialVersionUID = -5764411755432232219L;

        public SymbolRedefinitionException(String string) {
            super(string);
        }
    }

    public static class SymbolMissingException
    extends RuntimeException {
        private static final long serialVersionUID = -342580227434108373L;

        public SymbolMissingException(String string) {
            super(string);
        }
    }
}

