/*
 * Decompiled with CFR 0.152.
 */
package obp2.cli;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.function.Supplier;
import obp2.algorithms.bitstate.BA_NestedDFS_Bitstate_Iterative;
import obp2.algorithms.bitstate.BitstateExplorer;
import obp2.algorithms.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import obp2.algorithms.reachability.BFSExplorer;
import obp2.algorithms.reachability.DFSExplorer;
import obp2.algorithms.verifiers.deadlock.DeadlockVerifier;
import obp2.cli.CounterExampleExtractor;
import obp2.cli.CounterExampleOnlyActions;
import obp2.cli.CounterExampleOnlyStates;
import obp2.cli.CounterExampleStatesAndActions;
import obp2.cli.PlugCLI;
import obp2.core.IGraphAccess;
import obp2.core.execution.Execution;
import obp2.core.registry.LanguageModuleRegistry;
import obp2.language.buchikripke.runtime.KripkeBuchiPlugin;
import obp2.runtime.core.ILanguageModule;
import obp2.visualisation.StateSpace2DOT;
import obp2.visualisation.StateSpace2ExplicitVHD;
import obp2.visualisation.StateSpace2MTX;
import obp2.visualisation.StateSpace2TGF;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import properties.LTL.transformations.LTL2Buchi;

class VerificationMain {
    @Argument(metaVar="<model-path>", usage="The path to the model file")
    Path modelPath;
    @Option(name="-p", aliases={"--property-file"}, usage="The path to the .gpsl property file")
    Path propertiesPath;
    @Option(name="-v", aliases={"--verify"}, metaVar="<property-name>", usage="The name of the property to verify", depends={"-p"})
    String propertyToVerify;
    @Option(name="-x", aliases={"--explore"}, usage="State-space exploration", forbids={"-v", "-d"})
    ExplorerEnum explorer = ExplorerEnum.BFS;
    @Option(name="-d", aliases={"--deadlock"}, usage="Check for deadlocks", forbids={"-v"})
    boolean checkForDeadlocks;
    @Option(name="-h", aliases={"--help"}, usage="Print this help message and exists", help=true)
    boolean help;
    @Option(name="-b", aliases={"--heartbeat"}, usage="Interactive binary heartbeat", forbids={"-progress"})
    boolean heartbeat = false;
    @Option(name="-progress", usage="Show progress during execution")
    boolean showProgress = false;
    @Option(name="-e", aliases={"--export"}, usage="Export the state-space", depends={"-o"})
    ExportFormatEnum exportFormat;
    @Option(name="-o", aliases={"--output"}, usage="Export output file", depends={"-e"})
    Path outputPath;
    @Option(name="-ts", aliases={"--transition-storage"}, usage="Set the transition storage backend")
    Execution.TransitionStorageType transitionStorageType = Execution.TransitionStorageType.PARENT;
    @Option(name="-bsc", aliases={"--bitstate-cycle"}, usage="Use the bitstate-hashing cycle detection algorithm")
    boolean useBitstateHashingCycleDetection = false;
    @Option(name="-wf", aliases={"--witness-format"}, usage="Specify the format of the witness trace")
    CounterExampleFormat counterExampleFormat = CounterExampleFormat.ACTION;
    @Option(name="-mpw", aliases={"--model-and-property-witness"}, usage="Show both the model and the property in the witness trace")
    boolean modelAndProperty = false;
    CounterExampleExtractor counterExampleHandler = null;

    VerificationMain() {
    }

    public void getHelp() {
        PlugCLI.instance.printHelp(System.out);
    }

    Supplier<ILanguageModule> getModelSupplier() {
        if (this.modelPath == null) {
            PlugCLI.instance.printHelp(System.out);
            return null;
        }
        return LanguageModuleRegistry.getLanguageModuleSupplier((Path)this.modelPath);
    }

    void run() {
        if (this.help) {
            this.getHelp();
            return;
        }
        PlugCLI.instance.printVersion(System.out);
        switch (this.counterExampleFormat) {
            case ACTION: {
                this.counterExampleHandler = new CounterExampleOnlyActions(this.propertyToVerify, this.checkForDeadlocks, !this.modelAndProperty);
                break;
            }
            case STATE: {
                this.counterExampleHandler = new CounterExampleOnlyStates(this.propertyToVerify, this.checkForDeadlocks, !this.modelAndProperty);
                break;
            }
            case STATE_ACTION: {
                this.counterExampleHandler = new CounterExampleStatesAndActions(this.propertyToVerify, this.checkForDeadlocks, !this.modelAndProperty);
            }
        }
        Execution execution = null;
        if (this.propertyToVerify != null) {
            if (this.propertyToVerify.equals("__")) {
                System.out.println("Buchi acceptance model-checking");
                execution = new Execution("Buchi acceptance", this.getModelSupplier(), this.useBitstateHashingCycleDetection ? BA_NestedDFS_Bitstate_Iterative::new : BA_GaiserSchwoon_Iterative::new, this.transitionStorageType);
            } else {
                System.out.println("LTL model-checking");
                try {
                    execution = new Execution(this.propertyToVerify, KripkeBuchiPlugin.getModelSupplier((String)this.propertyToVerify, (Path)this.propertiesPath, this.getModelSupplier()), this.useBitstateHashingCycleDetection ? BA_NestedDFS_Bitstate_Iterative::new : BA_GaiserSchwoon_Iterative::new, this.transitionStorageType);
                }
                catch (Exception e) {
                    if (e instanceof LTL2Buchi.PropertyNotFoundException) {
                        System.err.println(e.getMessage());
                        return;
                    }
                    e.printStackTrace();
                    return;
                }
            }
        } else if (this.checkForDeadlocks) {
            System.out.println("Deadlock checking");
            execution = new Execution("Deadlock", this.getModelSupplier(), DeadlockVerifier::bfs, this.transitionStorageType);
        } else {
            switch (this.explorer) {
                case BFS: {
                    System.out.println("BFS state-space exploration");
                    execution = new Execution("BFS", this.getModelSupplier(), BFSExplorer::new, this.transitionStorageType);
                    break;
                }
                case DFS: {
                    System.out.println("DFS state-space exploration");
                    execution = new Execution("DFS", this.getModelSupplier(), DFSExplorer::new, this.transitionStorageType);
                    break;
                }
                case Bitstate: {
                    System.out.println("Bitstate state-space explorer");
                    execution = new Execution("Bitstate", this.getModelSupplier(), BitstateExplorer::new, Execution.TransitionStorageType.NONE);
                }
            }
        }
        if (execution == null) {
            System.err.println("Could not create the execution instance");
            return;
        }
        execution.initialize();
        if (execution.status == Execution.Status.FAILED) {
            System.err.println(execution.getException().getMessage());
            System.exit(1);
        }
        Thread runnerThread = execution.run();
        boolean stopped = false;
        if (this.heartbeat) {
            Execution exe = execution;
            boolean[] stop = new boolean[]{false};
            Thread heartbeat = new Thread(() -> {
                stop[0] = this.handleRequests(exe);
            });
            heartbeat.run();
            try {
                heartbeat.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            stopped = stop[0];
        } else if (this.showProgress) {
            while (runnerThread.isAlive()) {
                try {
                    BigInteger confs = execution.configurationCount();
                    System.out.print(confs + " configurations [" + confs.divide(BigInteger.valueOf(Math.max(execution.getElapsedTime() / 1000L, 1L))) + " confs/sec]\r");
                    Thread.sleep(500L);
                }
                catch (InterruptedException confs) {}
            }
        }
        try {
            runnerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (execution.status == Execution.Status.FAILED && execution.getException() != null) {
            System.err.println(execution.getException().getMessage());
            execution.getException().printStackTrace();
            return;
        }
        if (!this.heartbeat) {
            System.out.println("Model loaded in " + execution.getLoadingTime() + " ms\n\"" + execution.getName() + "\" Analysis " + (stopped ? Execution.CompletenessStatus.INCOMPLETE : execution.resultStatus()) + " " + execution.configurationCount() + " states " + execution.stepCount() + " transitions in " + execution.getElapsedTime() + " ms\n" + (this.propertyToVerify != null || this.checkForDeadlocks ? execution.verificationStatus() : ""));
            try {
                this.counterExampleHandler.buildCounterExample(execution).toStringCounterExample(System.out);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.handleStateSpaceExport(execution);
    }

    void handleStateSpaceExport(Execution execution) {
        if (this.exportFormat != null) {
            switch (this.exportFormat) {
                case TGF: {
                    System.out.println("Exporting the state-space to TGF");
                    StateSpace2TGF.toTGF((IGraphAccess)execution.getGraphView(), (String)this.outputPath.toAbsolutePath().toString());
                    System.out.println("TGF state-space generated " + this.outputPath.toAbsolutePath().toString());
                    break;
                }
                case MTX: {
                    System.out.println("Exporting the state-space to MTX");
                    StateSpace2MTX.toMTX((IGraphAccess)execution.getGraphView(), (String)this.outputPath.toAbsolutePath().toString());
                    System.out.println("MTX state-space generated " + this.outputPath.toAbsolutePath().toString());
                    break;
                }
                case DOT: {
                    System.out.println("Exporting the state-space to DOT");
                    StateSpace2DOT.toDOT((IGraphAccess)execution.getGraphView(), (boolean)false, (String)this.outputPath.toAbsolutePath().toString());
                    System.out.println("DOT state-space generated " + this.outputPath.toAbsolutePath().toString());
                    break;
                }
                case VHD: {
                    System.out.println("Exporting the state-space to VHDL");
                    StateSpace2ExplicitVHD.toVHD((IGraphAccess)execution.getGraphView(), (String)this.modelPath.toString(), (String)this.outputPath.toAbsolutePath().toString());
                    System.out.println("VHDL state-space generated " + this.outputPath.toAbsolutePath().toString());
                    break;
                }
            }
        }
    }

    boolean handleRequests(Execution execution) {
        BufferedInputStream bis = new BufferedInputStream(System.in);
        try {
            block9: while (true) {
                switch (bis.read()) {
                    case 104: {
                        long loading = execution.getLoadingTime();
                        long elapsed = execution.getElapsedTime();
                        BigInteger configurations = execution.configurationCount();
                        Execution.CompletenessStatus completenessStatus = execution.resultStatus();
                        Execution.VerificationStatus verificationStatus = execution.verificationStatus();
                        System.out.println("heartbeat [loading: " + loading + ", elapsed: " + elapsed + ", configurations: " + configurations + ", completeness: " + completenessStatus + ", verification: " + verificationStatus + "]");
                        continue block9;
                    }
                    case 112: {
                        execution.pause();
                        System.out.println("Paused");
                        continue block9;
                    }
                    case 115: {
                        boolean stopped = true;
                        if (execution.status() == Execution.Status.FINISHED) {
                            stopped = false;
                        }
                        execution.stop();
                        System.out.println("Stopped");
                        return stopped;
                    }
                    case 114: {
                        execution.resume();
                        System.out.println("Resumed");
                        continue block9;
                    }
                    case 119: {
                        this.counterExampleHandler.buildCounterExample(execution).toBinaryCounterExample(System.out);
                        continue block9;
                    }
                }
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    static enum CounterExampleFormat {
        ACTION,
        STATE,
        STATE_ACTION;

    }

    static enum ExportFormatEnum {
        TGF,
        MTX,
        DOT,
        VHD;

    }

    static enum ExplorerEnum {
        BFS,
        DFS,
        Bitstate;

    }
}

