/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.simulation.trace;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import obp2.core.IFiredTransition;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.simulation.trace_storage.TraceEntry;
import obp2.simulation.trace_storage.TraceStore;
import obp2.ui2.simulation.trace.SimulationGraphViewModel;
import org.kordamp.ikonli.javafx.FontIcon;
import org.reactfx.util.TriFunction;
import plug.utils.Pair;
import plug.utils.ui.graph.GraphView;

public class BranchingTraceView<C, A, O>
extends BorderPane {
    ObjectProperty<TraceStore<C, A, O>> traceStoreProperty;
    GraphView<TraceEntry<C, A, O>, Pair<A, O>> graphView;
    SimulationGraphViewModel<C, A, O> graphViewModel;
    ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty;
    ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty;
    private BooleanProperty collapsedConfigurationProperty = new SimpleBooleanProperty(false);
    BooleanProperty showDifferencesProperty = new SimpleBooleanProperty(true);
    BooleanProperty isFirst = new SimpleBooleanProperty(true);

    public BranchingTraceView(ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty, ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty, ObjectProperty<IFiredTransition<C, A, O>> inFiredTransition, ObjectProperty<TraceStore<C, A, O>> inoutTraceStore, ObjectProperty<TraceEntry<C, A, O>> outCurrentEntry, TriFunction<TraceEntry<C, A, O>, BooleanProperty, BooleanProperty, Node> configurationViewBuilder) {
        this.graphView = new GraphView();
        this.graphView.setPrefSize(400.0, 300.0);
        this.graphViewModel = new SimulationGraphViewModel<C, A, O>(transitionRelationProperty, runtimeViewProperty, configurationViewBuilder, this.showDifferencesProperty, this.collapsedConfigurationProperty);
        this.graphView.setModel(this.graphViewModel);
        this.traceStoreProperty = inoutTraceStore;
        TraceStore traceStore = (TraceStore)this.traceStoreProperty.get();
        if (traceStore == null) {
            traceStore = new TraceStore();
            this.traceStoreProperty.set((Object)traceStore);
        }
        traceStore.setAddRootUserCallback(this::addRootCallback);
        traceStore.setAddStepUserCallback(this::addStepCallback);
        traceStore.iterateOverTrace();
        this.graphView.setSelectedVertex((Object)traceStore.getLastEntry());
        if (traceStore.getLastEntry() != null) {
            outCurrentEntry.set((Object)traceStore.getLastEntry());
        }
        this.transitionRelationProperty = transitionRelationProperty;
        this.runtimeViewProperty = runtimeViewProperty;
        this.graphView.setNodeFolding(true);
        this.graphView.beHorizontal();
        this.setCenter((Node)this.graphView);
        ToggleButton hideDetailsButton = new ToggleButton(null, (Node)new FontIcon("gmi-photo-size-select-small"));
        hideDetailsButton.setTooltip(new Tooltip("Show/hide details in configurations"));
        hideDetailsButton.selectedProperty().bindBidirectional((Property)this.graphView.hideAllDetailsProperty());
        ToggleButton collapsedConfigurationsButton = new ToggleButton("Collapse", null);
        collapsedConfigurationsButton.setTooltip(new Tooltip("Collapse/expand all configuration trees"));
        collapsedConfigurationsButton.selectedProperty().bindBidirectional((Property)this.collapsedConfigurationProperty());
        collapsedConfigurationsButton.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.collapsedConfigurationProperty().get() ? "Collapse All" : "Expand All", (Observable[])new Observable[]{this.collapsedConfigurationProperty}));
        ToggleButton showDifferencesButton = new ToggleButton("Show differences", null);
        showDifferencesButton.setTooltip(new Tooltip("Show everything / Hide "));
        showDifferencesButton.selectedProperty().bindBidirectional((Property)this.showDifferencesProperty());
        showDifferencesButton.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.showDifferencesProperty().get() ? "Show everything" : "Only differences", (Observable[])new Observable[]{this.showDifferencesProperty}));
        ToggleButton coloredButton = new ToggleButton(null, (Node)new FontIcon("gmi-color-lens"));
        coloredButton.setTooltip(new Tooltip("Show/hide colors of configurations"));
        coloredButton.selectedProperty().bindBidirectional((Property)this.graphView.coloredNodesProperty());
        ToggleButton orientationButton = new ToggleButton(null, (Node)new FontIcon("gmi-screen-rotation"));
        orientationButton.setTooltip(new Tooltip("Change trace orientation"));
        orientationButton.selectedProperty().bindBidirectional((Property)this.graphView.isVerticalProperty());
        Button saveImageButton = new Button(null, (Node)new FontIcon("gmi-save"));
        saveImageButton.setTooltip(new Tooltip("Save an image of the current trace"));
        saveImageButton.setOnAction(event -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select file where to save image");
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG image", new String[]{"*.png"}));
            File file = chooser.showSaveDialog(this.getScene().getWindow());
            if (file != null) {
                try {
                    this.graphView.savePngImage(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        HBox toolkitPane = new HBox(5.0, new Node[]{collapsedConfigurationsButton, showDifferencesButton, hideDetailsButton, coloredButton, orientationButton, new Separator(Orientation.VERTICAL), saveImageButton});
        toolkitPane.setPadding(new Insets(5.0));
        this.setBottom((Node)toolkitPane);
        this.graphView.selectedVertexProperty().addListener((a, o, n) -> {
            if (n == null) {
                outCurrentEntry.set(null);
                return;
            }
            outCurrentEntry.set(n);
        });
        inFiredTransition.addListener((observable, o, n) -> {
            TraceEntry sourceEntry = (TraceEntry)this.graphView.getSelectedVertex();
            TraceEntry firstBranch = null;
            for (Object target : n.getTargets()) {
                TraceEntry targetEntry = ((TraceStore)this.traceStoreProperty.get()).addStep(sourceEntry, target, n.getTransition());
                if (firstBranch != null) continue;
                firstBranch = targetEntry;
            }
            this.graphView.setSelectedVertex(firstBranch);
        });
    }

    public void setInitialConfigurations(Set<C> initialConfigurations) {
        ((TraceStore)this.traceStoreProperty.get()).addRoots(initialConfigurations);
    }

    public void setCounterExample(List<C> counterExample) {
        TraceEntry entry = ((TraceStore)this.traceStoreProperty.get()).addSteps((TraceEntry)this.graphView.getSelectedVertex(), counterExample, (arg_0, arg_1) -> ((ITransitionRelation)((ITransitionRelation)this.transitionRelationProperty.get())).transitionFromSourceToTarget(arg_0, arg_1));
        this.graphView.setSelectedVertex((Object)entry);
    }

    void addStepCallback(TraceEntry<C, A, O> entry) {
        this.graphViewModel.addEdge(entry.getParent(), entry, entry.getTransition());
    }

    void addRootCallback(TraceEntry<C, A, O> entry) {
        this.graphViewModel.getInitialVertices().add(entry);
        if (this.isFirst.get()) {
            this.graphView.setSelectedVertex(entry);
            this.isFirst.set(false);
        }
    }

    public BooleanProperty collapsedConfigurationProperty() {
        return this.collapsedConfigurationProperty;
    }

    private BooleanProperty showDifferencesProperty() {
        return this.showDifferencesProperty;
    }
}

