/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.simulation;

import announce4j.Announcer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.VBox;
import obp2.algorithms.reachability.BFSExplorer;
import obp2.algorithms.verifiers.deadlock.DeadlockVerifier;
import obp2.algorithms.verifiers.deadlock.FinalStateDetected;
import obp2.core.IStateSpaceManager;
import obp2.events.PropertyEvent;
import obp2.folding.runtime.PreinitializedRuntime;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.simulation.trace_storage.TraceEntry;
import obp2.simulation.trace_storage.TraceStore;
import obp2.statespace.SimpleStateSpaceManager;
import obp2.ui2.simulation.configuration.ConfigurationTreeView;
import obp2.ui2.simulation.configuration.ConfigurationTreeViewTitledPane;
import obp2.ui2.simulation.expression_watcher.ExpressionWatcherTitledPane;
import obp2.ui2.simulation.fireables.FireableTransitionsView;
import obp2.ui2.simulation.trace.BranchingTraceView;
import plug.utils.graph.IGraph;
import plug.utils.graph.algorithms.DijkstraShortestPath;

public class SimulationView<C, A, O>
extends SplitPane {
    ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty;
    ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty;
    ObjectProperty<C> theCurrentConfiguration = new SimpleObjectProperty();
    ObjectProperty<TraceEntry<C, A, O>> theCurrentEntry = new SimpleObjectProperty();
    BranchingTraceView<C, A, O> branchingTraceView;

    public SimulationView(ObjectProperty<ITransitionRelation<C, A, O>> transitionRelation, ObjectProperty<ITreeProjector<C, A, O>> runtimeView, ObjectProperty<Set<C>> initialSet) {
        this(transitionRelation, runtimeView, initialSet, (ObjectProperty<TraceStore<C, A, O>>)new SimpleObjectProperty());
    }

    public SimulationView(ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty, ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty, ObjectProperty<Set<C>> initialSet, ObjectProperty<TraceStore<C, A, O>> inoutTraceStoreProperty) {
        this.transitionRelationProperty = transitionRelationProperty;
        this.runtimeViewProperty = runtimeViewProperty;
        SimpleObjectProperty theFiredTransition = new SimpleObjectProperty();
        FireableTransitionsView<C, A, O> fireableTransitionsView = new FireableTransitionsView<C, A, O>(this.theCurrentEntry, transitionRelationProperty, runtimeViewProperty, theFiredTransition, inoutTraceStoreProperty);
        ConfigurationTreeViewTitledPane<C, A, O> configurationTitledPane = new ConfigurationTreeViewTitledPane<C, A, O>(this.theCurrentConfiguration, runtimeViewProperty);
        configurationTitledPane.addToolbarAction("gmi-keyboard-tab:18:#2ecc71", Bindings.createStringBinding(() -> "Find deadlock", (Observable[])new Observable[0]), this::deadlockFinder);
        ExpressionWatcherTitledPane<C, A, O> watchTitledPane = new ExpressionWatcherTitledPane<C, A, O>(this.theCurrentConfiguration, transitionRelationProperty, this::addCounterExample);
        VBox accordion = new VBox(new Node[]{watchTitledPane, configurationTitledPane});
        ScrollPane accordionScrollPane = new ScrollPane((Node)accordion);
        accordionScrollPane.setFitToWidth(true);
        SplitPane topPane = new SplitPane(new Node[]{fireableTransitionsView, accordionScrollPane});
        this.branchingTraceView = new BranchingTraceView<C, A, O>(transitionRelationProperty, runtimeViewProperty, theFiredTransition, inoutTraceStoreProperty, this.theCurrentEntry, this::configurationViewBuilder);
        this.getItems().addAll((Object[])new Node[]{topPane, this.branchingTraceView});
        this.setOrientation(Orientation.VERTICAL);
        this.setDividerPosition(0, 0.3);
        Set<C> initialConfigurations = this.getInitialConfigurations((Set)initialSet.get(), (ITransitionRelation)transitionRelationProperty.get());
        this.branchingTraceView.setInitialConfigurations(initialConfigurations);
        initialSet.addListener((v, o, n) -> {
            Set<C> initials = this.getInitialConfigurations((Set)initialSet.get(), (ITransitionRelation)transitionRelationProperty.get());
            this.branchingTraceView.setInitialConfigurations(initials);
        });
        this.theCurrentConfiguration.bind((ObservableValue)Bindings.createObjectBinding(() -> ((TraceEntry)this.theCurrentEntry.get()).getConfiguration(), (Observable[])new Observable[]{this.theCurrentEntry}));
    }

    Node configurationViewBuilder(TraceEntry<C, A, O> entry, BooleanProperty inShowDifferencesProperty, BooleanProperty inExpandedTreeProperty) {
        SimpleObjectProperty theCurrentConfiguration = new SimpleObjectProperty();
        SimpleBooleanProperty theShowDifferencesProperty = new SimpleBooleanProperty(true);
        SimpleBooleanProperty theExpandedTreeProperty = new SimpleBooleanProperty(false);
        inShowDifferencesProperty.addListener((arg_0, arg_1, arg_2) -> SimulationView.lambda$configurationViewBuilder$3((BooleanProperty)theShowDifferencesProperty, arg_0, arg_1, arg_2));
        inExpandedTreeProperty.addListener((arg_0, arg_1, arg_2) -> SimulationView.lambda$configurationViewBuilder$4((BooleanProperty)theExpandedTreeProperty, arg_0, arg_1, arg_2));
        ConfigurationTreeView<C, A, O> view = new ConfigurationTreeView<C, A, O>(theCurrentConfiguration, this.runtimeViewProperty, (BooleanProperty)theShowDifferencesProperty, (BooleanProperty)theExpandedTreeProperty);
        view.addContextMenuAction("gmi-keyboard-tab:18:#2ecc71", Bindings.createStringBinding(() -> "Find deadlock", (Observable[])new Observable[0]), this::deadlockFinder);
        if (entry.getParentConfiguration() != null) {
            theCurrentConfiguration.set(entry.getParentConfiguration());
        }
        theCurrentConfiguration.set(entry.getConfiguration());
        return view;
    }

    void deadlockFinder(Event event) {
        PreinitializedRuntime preinitializedRuntime = new PreinitializedRuntime((ITransitionRelation)this.transitionRelationProperty.get(), Collections.singleton(this.theCurrentConfiguration.get()));
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        stateSpaceManager.parentTransitionStorage();
        BFSExplorer deadlockVerifier = DeadlockVerifier.bfs((ITransitionRelation)preinitializedRuntime, (IStateSpaceManager)stateSpaceManager);
        deadlockVerifier.getAnnouncer().when(FinalStateDetected.class, (arg_0, arg_1) -> this.lambda$deadlockFinder$6((IStateSpaceManager)stateSpaceManager, arg_0, arg_1));
        deadlockVerifier.getAnnouncer().when(PropertyEvent.class, (ann, e) -> {
            if (e.isVerified()) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION, "No deadlock found", new ButtonType[0]);
                alert.setTitle("Congratulations");
                alert.setHeaderText(null);
                alert.showAndWait();
            }
        });
        deadlockVerifier.execute();
    }

    void deadlockFoundCallback(FinalStateDetected event, IStateSpaceManager stateSpaceManager, Consumer<List<C>> counterExampleHandler) {
        List counterExample = new DijkstraShortestPath().getShortestPath((IGraph)stateSpaceManager.getGraphView(), (Collection)stateSpaceManager.initialConfigurations(), (Object)event.getFinalState());
        counterExampleHandler.accept(counterExample);
    }

    Set<C> getInitialConfigurations(Set<C> initialSet, ITransitionRelation<C, A, ?> transitionRelation) {
        if (transitionRelation == null) {
            return Collections.emptySet();
        }
        if (initialSet == null) {
            initialSet = transitionRelation.initialConfigurations();
        }
        return initialSet;
    }

    public void addCounterExample(List<C> counterExample) {
        this.branchingTraceView.setCounterExample(counterExample);
    }

    private /* synthetic */ void lambda$deadlockFinder$6(IStateSpaceManager stateSpaceManager, Announcer ann, FinalStateDetected e) {
        this.deadlockFoundCallback(e, stateSpaceManager, this::addCounterExample);
    }

    private static /* synthetic */ void lambda$configurationViewBuilder$4(BooleanProperty theExpandedTreeProperty, ObservableValue a, Boolean o, Boolean n) {
        theExpandedTreeProperty.setValue(n);
    }

    private static /* synthetic */ void lambda$configurationViewBuilder$3(BooleanProperty theShowDifferencesProperty, ObservableValue a, Boolean o, Boolean n) {
        theShowDifferencesProperty.setValue(n);
    }
}

