/*
 * Decompiled with CFR 0.152.
 */
package obp2.statespace.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.statespace.ITransitionStorage;

public class TargetOnlyTransitionStorage<C extends IConfiguration, A, O>
implements ITransitionStorage<C, A, O> {
    Map<C, Set<C>> adjacencyList = new HashMap<C, Set<C>>();
    int size = 0;
    int edgeCount = 0;

    @Override
    public IFiredTransition put(IFiredTransition<C, A, O> transition) {
        ++this.size;
        this.edgeCount += transition.getTargets().size();
        Set<C> fanout = this.adjacencyList.get(transition.getSource());
        if (fanout == null) {
            fanout = new HashSet<C>();
            this.adjacencyList.put(transition.getSource(), fanout);
        }
        fanout.addAll(transition.getTargets());
        return transition;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public C getParent(C configuration) {
        for (Map.Entry<C, Set<C>> entry : this.adjacencyList.entrySet()) {
            for (IConfiguration target : entry.getValue()) {
                if (target != configuration) continue;
                return (C)((IConfiguration)entry.getKey());
            }
        }
        return null;
    }

    @Override
    public Collection<IFiredTransition<C, A, O>> getFiredFrom(C configuration) {
        Set<C> result = this.adjacencyList.get(configuration);
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<IFiredTransition<C, A, O>> fired = new ArrayList<IFiredTransition<C, A, O>>(result.size());
        for (IConfiguration target : result) {
            fired.add((IFiredTransition<C, A, O>)new FiredTransition(configuration, (Object)target, null));
        }
        return fired;
    }

    @Override
    public Collection<IFiredTransition<C, A, O>> getFiredTo(C configuration) {
        return Collections.emptyList();
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }
}

