/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.reactfx.collection.ListModification;
import org.reactfx.collection.ListModificationImpl;
import org.reactfx.collection.ListModificationLike;
import org.reactfx.collection.MaterializedListModification;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModificationImpl;

public interface QuasiListModification<E>
extends ListModificationLike<E> {
    public static <E> QuasiListModification<E> create(int position, List<? extends E> removed, int addedSize) {
        return new QuasiListModificationImpl<E>(position, removed, addedSize);
    }

    public static <E, F extends E> QuasiListModification<E> fromCurrentStateOf(ListChangeListener.Change<F> ch) {
        ArrayList removed;
        ObservableList list = ch.getList();
        int from = ch.getFrom();
        int addedSize = ch.getTo() - from;
        if (ch.wasPermutated()) {
            removed = new ArrayList(addedSize);
            for (int i = 0; i < addedSize; ++i) {
                int pi = ch.getPermutation(from + i);
                removed.add(list.get(pi));
            }
        } else {
            removed = ch.getRemoved();
        }
        return new QuasiListModificationImpl(from, removed, addedSize);
    }

    public static <E> ListModification<E> instantiate(QuasiListModification<? extends E> template, ObservableList<E> list) {
        return new ListModificationImpl(template.getFrom(), template.getRemoved(), template.getAddedSize(), list);
    }

    public static <E> MaterializedListModification<E> materialize(QuasiListModification<? extends E> template, ObservableList<E> list) {
        return MaterializedListModification.create(template.getFrom(), template.getRemoved(), new ArrayList(list.subList(template.getFrom(), template.getTo())));
    }

    default public ListModification<E> instantiate(ObservableList<E> list) {
        return QuasiListModification.instantiate(this, list);
    }

    default public MaterializedListModification<E> materialize(ObservableList<E> list) {
        return QuasiListModification.materialize(this, list);
    }

    default public QuasiListChange<E> asListChange() {
        return () -> Collections.singletonList(this);
    }
}

