/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchi.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import obp2.language.buchi.runtime.BuchiConfiguration;
import obp2.runtime.core.IMarshaller;
import obp2.runtime.core.defaults.DefaultLanguageService;
import plug.utils.marshaling.Marshaller;
import plug.utils.marshaling.Unmarshaller;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.BuchiAutomata.BuchiAutomataModel.State;

public class BuchiMarshaller
extends DefaultLanguageService<BuchiConfiguration, GuardedTransition, Void>
implements IMarshaller<BuchiConfiguration, GuardedTransition, Void> {
    BuchiDeclaration buchi;
    Map<State, Integer> state2id = new IdentityHashMap<State, Integer>();
    Map<Integer, State> id2state = new IdentityHashMap<Integer, State>();
    Map<GuardedTransition, Integer> transition2id = new IdentityHashMap<GuardedTransition, Integer>();
    Map<Integer, GuardedTransition> id2transition = new IdentityHashMap<Integer, GuardedTransition>();
    int stateID = 0;
    int transitionID = 0;

    public BuchiMarshaller(BuchiDeclaration buchi) {
        this.buchi = buchi;
    }

    State getState(int id) {
        return this.id2state.get(id);
    }

    int getStateID(State state) {
        Integer id = this.state2id.get(state);
        if (id != null) {
            return id;
        }
        this.state2id.put(state, this.stateID);
        this.id2state.put(this.stateID, state);
        return this.stateID++;
    }

    GuardedTransition getTransition(int id) {
        return this.id2transition.get(id);
    }

    int getTransitionID(GuardedTransition transition) {
        Integer id = this.transition2id.get(transition);
        if (id != null) {
            return id;
        }
        this.transition2id.put(transition, this.transitionID);
        this.id2transition.put(this.transitionID, transition);
        return this.transitionID++;
    }

    public byte[] serializeConfiguration(BuchiConfiguration configuration) {
        int stateID = this.getStateID(configuration.buchiState);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
        try {
            Marshaller.writeInt((int)stateID, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serializeFireable(GuardedTransition fireable) {
        int transitionID = this.getTransitionID(fireable);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
        try {
            Marshaller.writeInt((int)transitionID, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serializeOutput(Void output) {
        return new byte[0];
    }

    public BuchiConfiguration deserializeConfiguration(byte[] buffer) {
        try {
            int stateID = Unmarshaller.readInt((InputStream)new ByteArrayInputStream(buffer));
            State state = this.getState(stateID);
            return new BuchiConfiguration(state);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GuardedTransition deserializeFireable(byte[] buffer) {
        try {
            int transitionID = Unmarshaller.readInt((InputStream)new ByteArrayInputStream(buffer));
            GuardedTransition guardedTransition = this.getTransition(transitionID);
            return guardedTransition;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Void deserializeOutput(byte[] buffer) {
        return null;
    }
}

