/*
 * Decompiled with CFR 0.152.
 */
package obp2.hash;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;

public class ExternalHash {
    static long testArraysHashCode(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        long hash = 0L;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            hash = Arrays.hashCode(bytes);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Arrays.hashCode (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
        return hash;
    }

    static {
        String platform = System.getProperty("os.name").toLowerCase();
        String resource = "/obp2/hash/lib/";
        String suffix = "";
        if (platform.contains("mac")) {
            resource = resource + "Darwin_x86_64/libobp2hash.dylib";
            suffix = ".dylib";
        } else if (platform.contains("linux")) {
            resource = resource + "Linux_x86_64/libobp2hash.so";
            suffix = ".so";
        } else {
            resource = resource + "windows_x86_64/libobp2hash.dll";
            suffix = ".dll";
        }
        Path libraryPath = null;
        try (InputStream inStream = ExternalHash.class.getResourceAsStream(resource);){
            libraryPath = Files.createTempFile("libobp2hash", suffix, new FileAttribute[0]);
            try (OutputStream outStream = Files.newOutputStream(libraryPath, new OpenOption[0]);){
                byte[] buffer = new byte[10240];
                int len = inStream.read(buffer);
                while (len != -1) {
                    outStream.write(buffer, 0, len);
                    len = inStream.read(buffer);
                }
            }
            libraryPath.toFile().setExecutable(true, false);
            System.load(libraryPath.toString());
        }
        catch (IOException e) {
            System.err.println("Can't create temp file to extract libobp2hash");
        }
    }
}

