/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalXOR;
import properties.PropositionalLogic.PropositionalLogicModel.PropositionalLogicModelFactory;
import properties.PropositionalLogic.grammar.PropositionalLogicBaseListener;
import properties.PropositionalLogic.grammar.PropositionalLogicParser;
import properties.PropositionalLogic.parser.TreeAnnotator;

public class ASTBuilder
extends PropositionalLogicBaseListener
implements TreeAnnotator {
    public ParseTreeProperty<Object> values = new ParseTreeProperty();
    PropositionalLogicModelFactory factory = PropositionalLogicModelFactory.eINSTANCE;

    @Override
    public ParseTreeProperty<Object> getValues() {
        return this.values;
    }

    @Override
    public void exitLiteral(PropositionalLogicParser.LiteralContext ctx) {
        this.setValue((ParseTree)ctx, ctx.TRUE() == null ? this.factory.createFalse() : this.factory.createTrue());
    }

    @Override
    public void exitAtom(PropositionalLogicParser.AtomContext ctx) {
        Atom atom = this.factory.createAtom();
        String language = ctx.IDENTIFIER() != null ? ctx.IDENTIFIER().getText() : null;
        atom.setLanguage(language);
        String code = ctx.ATOMINLINE().getText();
        atom.setCode(code.substring(1, code.length() - 1));
        atom.setDelimiterString(code.substring(0, 1));
        this.setValue((ParseTree)ctx, atom);
    }

    @Override
    public void exitParenExp(PropositionalLogicParser.ParenExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.formula()));
    }

    @Override
    public void exitUnaryExp(PropositionalLogicParser.UnaryExpContext ctx) {
        LogicalNegation value = this.factory.createLogicalNegation();
        value.setOperatorToken(ctx.NEGATION().getText());
        value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitBinaryExp(PropositionalLogicParser.BinaryExpContext ctx) {
        switch (ctx.operator.getType()) {
            case 1: {
                LogicalConjunction value = this.factory.createLogicalConjunction();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 2: {
                LogicalDisjunction value = this.factory.createLogicalDisjunction();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 10: {
                LogicalXOR value = this.factory.createLogicalXOR();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 5: {
                LogicalImplication value = this.factory.createLogicalImplication();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 3: {
                LogicalEquivalence value = this.factory.createLogicalEquivalence();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
        }
        throw new RuntimeException("unexpected binary operator: " + ctx.operator.getText() + " (line: " + ctx.getStart().getLine() + ")\n");
    }

    @Override
    public void exitFormulaDeclaration(PropositionalLogicParser.FormulaDeclarationContext ctx) {
        ExpressionDeclaration value = this.factory.createExpressionDeclaration();
        value.setName(ctx.IDENTIFIER().getText());
        value.setExpression((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitFormulaDeclarationList(PropositionalLogicParser.FormulaDeclarationListContext ctx) {
        ArrayList<Object> value = new ArrayList<Object>();
        for (PropositionalLogicParser.FormulaDeclarationContext fctx : ctx.formulaDeclaration()) {
            value.add(this.getValue((ParseTree)fctx, ExpressionDeclaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitLetExp(PropositionalLogicParser.LetExpContext ctx) {
        LetExpression value = this.factory.createLetExpression();
        List declarations = (List)this.getValue((ParseTree)ctx.formulaDeclarationList(), List.class);
        value.getDeclarations().addAll((Collection)declarations);
        value.setExpression((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitBlock(PropositionalLogicParser.BlockContext ctx) {
        DeclarationBlock value = this.factory.createDeclarationBlock();
        for (PropositionalLogicParser.FormulaDeclarationContext fctx : ctx.formulaDeclaration()) {
            value.getDeclarations().add(this.getValue((ParseTree)fctx, ExpressionDeclaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitAtomExp(PropositionalLogicParser.AtomExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.atom()));
    }

    @Override
    public void exitLiteralExp(PropositionalLogicParser.LiteralExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.literal()));
    }

    @Override
    public void exitReferenceExp(PropositionalLogicParser.ReferenceExpContext ctx) {
        ExpressionReference value = this.factory.createExpressionReference();
        value.setName(ctx.IDENTIFIER().getText());
        this.setValue((ParseTree)ctx, value);
    }
}

