/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchikripke.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.registry.LanguageModuleRegistry;
import obp2.language.buchi.runtime.BuchiConfiguration;
import obp2.language.buchi.runtime.BuchiPlugin;
import obp2.language.buchi.runtime.BuchiRuntime;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiDescription;
import obp2.language.buchikripke.runtime.KripkeBuchiLanguageModule;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.LanguageModule;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.BuchiAutomata.analysis.AcceptAllExtractor;
import properties.LTL.transformations.LTL2Buchi;

public class KripkeBuchiPlugin
implements ILanguagePlugin<URI, KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> {
    public String[] getExtensions() {
        return new String[]{".kripkebuchi"};
    }

    public String getName() {
        return "Kripke-Buchi";
    }

    public boolean isOmegaRegular() {
        return true;
    }

    public Function<URI, ILanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void>> languageModuleFunction() {
        return this::getRuntime;
    }

    public ILanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> getRuntime(URI modelURI) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            KripkeBuchiDescription description = (KripkeBuchiDescription)mapper.readValue(modelURI.toURL(), KripkeBuchiDescription.class);
            Path modelPath = Paths.get(description.getModelPath(), new String[0]);
            Path resolvedModelPath = modelPath.isAbsolute() ? modelPath : Paths.get(modelURI).getParent().resolve(modelPath);
            StringBuilder ltl = new StringBuilder();
            description.getProperties().forEach((name, expression) -> {
                ltl.append((String)name);
                ltl.append(" = ");
                ltl.append((String)expression);
                ltl.append("\n");
            });
            BuchiDeclaration buchiAutomaton = new LTL2Buchi(new PrintWriter(System.out)).getBuchiDeclaration(ltl.toString());
            BuchiRuntime buchiRuntime = new BuchiRuntime(buchiAutomaton);
            return new KripkeBuchiLanguageModule((ILanguageModule)LanguageModuleRegistry.getLanguageModuleSupplier((Path)resolvedModelPath).get(), (ILanguageModule)BuchiPlugin.getLanguageModule((BuchiDeclaration)buchiAutomaton), description.getSemantics());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Supplier<ILanguageModule> getModelSupplier(String propertyToVerify, Path propertiesPath, Path modelPath) {
        return () -> KripkeBuchiPlugin.getRuntime(propertyToVerify, propertiesPath, modelPath);
    }

    private static ILanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> getRuntime(String propertyToVerify, Path propertiesPath, Path modelPath) {
        try {
            LanguageModule buchi = BuchiPlugin.getLanguageModule((Path)propertiesPath, (String)propertyToVerify);
            ILanguageModule kripke = LanguageModuleRegistry.getLanguageModule((Path)modelPath);
            return new KripkeBuchiLanguageModule(kripke, (ILanguageModule)buchi, KripkeBuchiLanguageModule.Semantics.SE_KRIPKE_TBA);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Supplier<ILanguageModule> getModelSupplier(String propertyToVerify, Path propertiesPath, Supplier<ILanguageModule> modelSupplier) {
        return () -> KripkeBuchiPlugin.getRuntime(propertyToVerify, propertiesPath, modelSupplier);
    }

    private static ILanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> getRuntime(String propertyToVerify, Path propertiesPath, Supplier<ILanguageModule> modelSupplier) {
        try {
            LanguageModule buchi = BuchiPlugin.getLanguageModule((Path)propertiesPath, (String)propertyToVerify);
            ILanguageModule kripke = modelSupplier.get();
            return new KripkeBuchiLanguageModule(kripke, (ILanguageModule)buchi, KripkeBuchiLanguageModule.Semantics.SE_KRIPKE_TBA);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Supplier<ILanguageModule> getModelSupplier(String propertyToVerify, String propertiesString, Supplier<ILanguageModule> modelSupplier) {
        return () -> KripkeBuchiPlugin.getRuntime(propertyToVerify, propertiesString, modelSupplier);
    }

    private static ILanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> getRuntime(String propertyToVerify, String propertiesString, Supplier<ILanguageModule> modelSupplier) {
        try {
            LanguageModule buchi = BuchiPlugin.getLanguageModule((String)propertiesString, (String)propertyToVerify);
            ILanguageModule kripke = modelSupplier.get();
            return new KripkeBuchiLanguageModule(kripke, (ILanguageModule)buchi, KripkeBuchiLanguageModule.Semantics.SE_KRIPKE_TBA);
        }
        catch (Exception var5) {
            throw new RuntimeException(var5);
        }
    }

    public static Map<String, Supplier<ILanguageModule>> getLanguageModuleSupplierMap(Path modelPath, Path propertiesPath) {
        try {
            Supplier kripkeSupplier = LanguageModuleRegistry.getLanguageModuleSupplier((Path)modelPath);
            Map buchiModuleSupplierMap = BuchiPlugin.getLanguageModuleSupplierMap((Path)propertiesPath);
            LinkedHashMap<String, Supplier<ILanguageModule>> moduleSupplierMap = new LinkedHashMap<String, Supplier<ILanguageModule>>();
            for (Map.Entry entry : buchiModuleSupplierMap.entrySet()) {
                moduleSupplierMap.put((String)entry.getKey(), () -> KripkeBuchiPlugin.lambda$getLanguageModuleSupplierMap$4((Supplier)kripkeSupplier, entry));
            }
            return moduleSupplierMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BuchiDeclaration getBuchiDeclaration(KripkeBuchiLanguageModule module) {
        return ((BuchiRuntime)module.buchi.getTransitionRelation()).buchiAutomaton;
    }

    public static boolean isInAcceptAll(Object inConfiguration, Object inModule, Set<Object> ioAcceptAllSet) {
        KripkeBuchiConfiguration iConfiguration = (KripkeBuchiConfiguration)((Object)inConfiguration);
        KripkeBuchiLanguageModule iModule = (KripkeBuchiLanguageModule)((Object)inModule);
        if (ioAcceptAllSet.isEmpty()) {
            ioAcceptAllSet.addAll(AcceptAllExtractor.acceptAllSet((BuchiDeclaration)KripkeBuchiPlugin.getBuchiDeclaration(iModule)));
        }
        return ioAcceptAllSet.contains(((BuchiConfiguration)iConfiguration.buchiState).buchiState);
    }

    private static /* synthetic */ ILanguageModule lambda$getLanguageModuleSupplierMap$4(Supplier kripkeSupplier, Map.Entry entry) {
        try {
            return new KripkeBuchiLanguageModule((ILanguageModule)kripkeSupplier.get(), (ILanguageModule)((Supplier)entry.getValue()).get(), KripkeBuchiLanguageModule.Semantics.SE_KRIPKE_TBA);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

